/*
 * Decompiled with CFR 0.152.
 */
package com.hbisoft.pickit;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.hbisoft.pickit.CallBackTask;
import com.hbisoft.pickit.DownloadAsyncTask;
import com.hbisoft.pickit.PickiTCallbacks;
import com.hbisoft.pickit.Utils;
import java.io.File;

public class PickiT
implements CallBackTask {
    private Context context;
    private final PickiTCallbacks pickiTCallbacks;
    private boolean isDriveFile = false;
    private boolean isFromUnknownProvider = false;
    private DownloadAsyncTask asyntask;
    private boolean unknownProviderCalledBefore = false;
    private Activity mActivity;

    public PickiT(Context context, PickiTCallbacks listener, Activity activity) {
        this.context = context;
        this.pickiTCallbacks = listener;
        this.mActivity = activity;
    }

    public void getPath(Uri uri, int APILevel) {
        if (APILevel >= 19) {
            if (this.isOneDrive(uri) || this.isDropBox(uri) || this.isGoogleDrive(uri)) {
                this.isDriveFile = true;
                this.downloadFile(uri);
            } else {
                String returnedPath = Utils.getRealPathFromURI_API19(this.context, uri);
                Log.e((String)"RETURNED -", (String)("" + returnedPath));
                MimeTypeMap mime = MimeTypeMap.getSingleton();
                String subStringExtension = String.valueOf(returnedPath).substring(String.valueOf(returnedPath).lastIndexOf(".") + 1);
                String extensionFromMime = mime.getExtensionFromMimeType(this.context.getContentResolver().getType(uri));
                if (returnedPath == null || returnedPath.equals("")) {
                    if (!this.unknownProviderCalledBefore) {
                        this.unknownProviderCalledBefore = true;
                        if (uri.getScheme() != null && uri.getScheme().equals("content")) {
                            if (Utils.errorReason() != null && Utils.errorReason().equals("dataReturnedNull")) {
                                this.isFromUnknownProvider = true;
                                this.downloadFile(uri);
                                return;
                            }
                            if (Utils.errorReason() != null && Utils.errorReason().contains("column '_data' does not exist")) {
                                this.isFromUnknownProvider = true;
                                this.downloadFile(uri);
                                return;
                            }
                            if (Utils.errorReason() != null && Utils.errorReason().equals("uri")) {
                                this.isFromUnknownProvider = true;
                                this.downloadFile(uri);
                                return;
                            }
                        }
                    }
                    this.pickiTCallbacks.PickiTonCompleteListener(returnedPath, false, false, false, Utils.errorReason());
                } else {
                    if (!subStringExtension.equals("jpeg") && !subStringExtension.equals(extensionFromMime) && uri.getScheme() != null && uri.getScheme().equals("content")) {
                        this.isFromUnknownProvider = true;
                        this.downloadFile(uri);
                        return;
                    }
                    this.pickiTCallbacks.PickiTonCompleteListener(returnedPath, false, false, true, "");
                }
            }
        } else {
            String returnedPath = Utils.getRealPathFromURI_BelowAPI19(this.context, uri);
            this.pickiTCallbacks.PickiTonCompleteListener(returnedPath, false, false, true, "");
        }
    }

    private void downloadFile(Uri uri) {
        this.asyntask = new DownloadAsyncTask(uri, this.context, this, this.mActivity);
        this.asyntask.execute(new Uri[0]);
    }

    public void cancelTask() {
        if (this.asyntask != null) {
            this.asyntask.cancel(true);
            this.deleteTemporaryFile(this.context);
        }
    }

    public boolean wasLocalFileSelected(Uri uri) {
        return !this.isDropBox(uri) && !this.isGoogleDrive(uri) && !this.isOneDrive(uri);
    }

    private boolean isDropBox(Uri uri) {
        return String.valueOf(uri).toLowerCase().contains("content://com.dropbox.");
    }

    private boolean isGoogleDrive(Uri uri) {
        return String.valueOf(uri).toLowerCase().contains("com.google.android.apps");
    }

    private boolean isOneDrive(Uri uri) {
        return String.valueOf(uri).toLowerCase().contains("com.microsoft.skydrive.content");
    }

    @Override
    public void PickiTonUriReturned() {
        this.pickiTCallbacks.PickiTonUriReturned();
    }

    @Override
    public void PickiTonPreExecute() {
        this.pickiTCallbacks.PickiTonStartListener();
    }

    @Override
    public void PickiTonProgressUpdate(int progress) {
        this.pickiTCallbacks.PickiTonProgressUpdate(progress);
    }

    @Override
    public void PickiTonPostExecute(String path, boolean wasDriveFile, boolean wasSuccessful, String reason) {
        this.unknownProviderCalledBefore = false;
        if (wasSuccessful) {
            if (this.isDriveFile) {
                this.pickiTCallbacks.PickiTonCompleteListener(path, true, false, true, "");
            } else if (this.isFromUnknownProvider) {
                this.pickiTCallbacks.PickiTonCompleteListener(path, false, true, true, "");
            }
        } else if (this.isDriveFile) {
            this.pickiTCallbacks.PickiTonCompleteListener(path, true, false, false, reason);
        } else if (this.isFromUnknownProvider) {
            this.pickiTCallbacks.PickiTonCompleteListener(path, false, true, false, reason);
        }
    }

    public void deleteTemporaryFile(Context context) {
        File folder = context.getExternalFilesDir("Temp");
        if (folder != null && this.deleteDirectory(folder)) {
            Log.i((String)"PickiT ", (String)" deleteDirectory was called");
        }
    }

    private boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            if (files == null) {
                return false;
            }
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                    continue;
                }
                boolean wasSuccessful = file.delete();
                if (!wasSuccessful) continue;
                Log.i((String)"Deleted ", (String)"successfully");
            }
        }
        return path.delete();
    }
}

