/*
 * Decompiled with CFR 0.152.
 */
package com.hbisoft.pickit;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import com.hbisoft.pickit.CallBackTask;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;

class DownloadAsyncTask
extends AsyncTask<Uri, Integer, String> {
    private Uri mUri;
    private CallBackTask callback;
    private WeakReference<Context> mContext;
    private String pathPlusName;
    private File folder;
    private Cursor returnCursor;
    private InputStream is = null;
    private String errorReason = "";
    private WeakReference<Activity> activityReference;

    DownloadAsyncTask(Uri uri, Context context, CallBackTask callback, Activity activity) {
        this.mUri = uri;
        this.mContext = new WeakReference<Context>(context);
        this.callback = callback;
        this.activityReference = new WeakReference<Activity>(activity);
    }

    protected void onPreExecute() {
        this.callback.PickiTonUriReturned();
    }

    protected void onProgressUpdate(Integer ... values) {
        super.onProgressUpdate((Object[])values);
        int post = values[0];
        this.callback.PickiTonProgressUpdate(post);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doInBackground(Uri ... params) {
        File file = null;
        int size = -1;
        Context context = (Context)this.mContext.get();
        if (context != null) {
            this.folder = context.getExternalFilesDir("Temp");
            if (this.folder != null && !this.folder.exists() && this.folder.mkdirs()) {
                Log.i((String)"PickiT : ", (String)"Temp folder createdd");
            }
            this.returnCursor = context.getContentResolver().query(this.mUri, null, null, null, null);
            try {
                this.is = context.getContentResolver().openInputStream(this.mUri);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        ((Activity)this.activityReference.get()).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DownloadAsyncTask.this.callback.PickiTonPreExecute();
            }
        });
        try {
            int count;
            try {
                if (this.returnCursor != null && this.returnCursor.moveToFirst() && this.mUri.getScheme() != null) {
                    if (this.mUri.getScheme().equals("content")) {
                        int sizeIndex = this.returnCursor.getColumnIndex("_size");
                        size = (int)this.returnCursor.getLong(sizeIndex);
                    } else if (this.mUri.getScheme().equals("file")) {
                        File ff = new File(this.mUri.getPath());
                        size = (int)ff.length();
                    }
                }
            }
            finally {
                if (this.returnCursor != null) {
                    this.returnCursor.close();
                }
            }
            this.pathPlusName = this.folder + "/" + this.getFileName(this.mUri, (Context)this.mContext.get());
            file = new File(this.folder + "/" + this.getFileName(this.mUri, (Context)this.mContext.get()));
            BufferedInputStream bis = new BufferedInputStream(this.is);
            FileOutputStream fos = new FileOutputStream(file);
            byte[] data = new byte[1024];
            long total = 0L;
            while ((count = bis.read(data)) != -1) {
                if (this.isCancelled()) continue;
                total += (long)count;
                if (size != -1) {
                    try {
                        this.publishProgress(new Integer[]{(int)(total * 100L / (long)size)});
                    }
                    catch (Exception e) {
                        Log.i((String)"PickiT -", (String)"File size is less than 1");
                        this.publishProgress(new Integer[]{0});
                    }
                }
                fos.write(data, 0, count);
            }
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            Log.e((String)"Pickit IOException = ", (String)e.getMessage());
            this.errorReason = e.getMessage();
        }
        return file.getAbsolutePath();
    }

    private String getFileName(Uri uri, Context context) {
        String result = null;
        if (uri.getScheme() != null && uri.getScheme().equals("content")) {
            Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                result = cursor.getString(cursor.getColumnIndex("_display_name"));
            }
            if (cursor != null) {
                cursor.close();
            }
        }
        if (result == null) {
            result = uri.getPath();
            assert (result != null);
            int cut = result.lastIndexOf(47);
            if (cut != -1) {
                result = result.substring(cut + 1);
            }
        }
        return result;
    }

    protected void onPostExecute(String result) {
        if (result == null) {
            this.callback.PickiTonPostExecute(this.pathPlusName, true, false, this.errorReason);
        } else {
            this.callback.PickiTonPostExecute(this.pathPlusName, true, true, "");
        }
    }
}

