/*
 * Decompiled with CFR 0.152.
 */
package com.hbisoft.hbrecorder;

import android.os.Handler;
import android.os.Looper;
import com.hbisoft.hbrecorder.MyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

class FileObserver
extends android.os.FileObserver {
    private List<SingleFileObserver> mObservers;
    private final String mPath;
    private final int mMask;
    private final MyListener ml;

    FileObserver(String path, MyListener ml) {
        super(path, 4095);
        this.mPath = path;
        this.mMask = 4095;
        this.ml = ml;
    }

    public void startWatching() {
        if (this.mObservers != null) {
            return;
        }
        this.mObservers = new ArrayList<SingleFileObserver>();
        Stack<String> stack = new Stack<String>();
        stack.push(this.mPath);
        while (!stack.isEmpty()) {
            String parent = (String)stack.pop();
            this.mObservers.add(new SingleFileObserver(parent, this.mMask));
            File path = new File(parent);
            File[] files = path.listFiles();
            if (null == files) continue;
            for (File f : files) {
                if (!f.isDirectory() || f.getName().equals(".") || f.getName().equals("..")) continue;
                stack.push(f.getPath());
            }
        }
        for (SingleFileObserver sfo : this.mObservers) {
            sfo.startWatching();
        }
    }

    public void stopWatching() {
        if (this.mObservers == null) {
            return;
        }
        for (SingleFileObserver sfo : this.mObservers) {
            sfo.stopWatching();
        }
        this.mObservers.clear();
        this.mObservers = null;
    }

    public void onEvent(int event, String path) {
        if (event == 8) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    FileObserver.this.ml.onCompleteCallback();
                }
            });
        }
    }

    class SingleFileObserver
    extends android.os.FileObserver {
        final String mPath;

        SingleFileObserver(String path, int mask) {
            super(path, mask);
            this.mPath = path;
        }

        public void onEvent(int event, String path) {
            String newPath = this.mPath + "/" + path;
            FileObserver.this.onEvent(event, newPath);
        }
    }
}

