/*
 * Decompiled with CFR 0.152.
 */
package com.hbisoft.hbrecorder;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Icon;
import android.hardware.display.VirtualDisplay;
import android.media.MediaRecorder;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.IBinder;
import android.os.ResultReceiver;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.hbisoft.hbrecorder.HBRecorderCodecInfo;
import com.hbisoft.hbrecorder.NotificationReceiver;
import com.hbisoft.hbrecorder.R;
import java.io.FileDescriptor;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Objects;

public class ScreenRecordService
extends Service {
    private static final String TAG = "ScreenRecordService";
    private long maxFileSize = 0L;
    private boolean hasMaxFileBeenReached = false;
    private int mScreenWidth;
    private int mScreenHeight;
    private int mScreenDensity;
    private int mResultCode;
    private Intent mResultData;
    private boolean isVideoHD;
    private boolean isAudioEnabled;
    private String path;
    private MediaProjection mMediaProjection;
    private MediaRecorder mMediaRecorder;
    private VirtualDisplay mVirtualDisplay;
    private String name;
    private int audioBitrate;
    private int audioSamplingRate;
    private static String filePath;
    private static String fileName;
    private int audioSourceAsInt;
    private int videoEncoderAsInt;
    private boolean isCustomSettingsEnabled;
    private int videoFrameRate;
    private int videoBitrate;
    private int outputFormatAsInt;
    private int orientationHint;
    public static final String BUNDLED_LISTENER = "listener";
    private Uri returnedUri = null;
    private Intent mIntent;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresApi(api=21)
    public int onStartCommand(final Intent intent, int flags, int startId) {
        boolean isAction = false;
        if (intent != null) {
            Bundle bundle;
            ResultReceiver receiver;
            block31: {
                block30: {
                    block29: {
                        if (intent.getAction() != null) {
                            isAction = true;
                        }
                        if (isAction) {
                            if (intent.getAction().equals("pause")) {
                                if (Build.VERSION.SDK_INT < 24) return 1;
                                this.pauseRecording();
                                return 1;
                            } else {
                                if (!intent.getAction().equals("resume") || Build.VERSION.SDK_INT < 24) return 1;
                                this.resumeRecording();
                            }
                            return 1;
                        }
                        this.hasMaxFileBeenReached = false;
                        this.mIntent = intent;
                        this.maxFileSize = intent.getLongExtra("maxFileSize", 0L);
                        byte[] notificationSmallIcon = intent.getByteArrayExtra("notificationSmallBitmap");
                        int notificationSmallVector = intent.getIntExtra("notificationSmallVector", 0);
                        String notificationTitle = intent.getStringExtra("notificationTitle");
                        String notificationDescription = intent.getStringExtra("notificationDescription");
                        String notificationButtonText = intent.getStringExtra("notificationButtonText");
                        this.orientationHint = intent.getIntExtra("orientation", 400);
                        this.mResultCode = intent.getIntExtra("code", -1);
                        this.mResultData = (Intent)intent.getParcelableExtra("data");
                        this.mScreenWidth = intent.getIntExtra("width", 0);
                        this.mScreenHeight = intent.getIntExtra("height", 0);
                        if (intent.getStringExtra("mUri") != null) {
                            this.returnedUri = Uri.parse((String)intent.getStringExtra("mUri"));
                        }
                        if (this.mScreenHeight == 0 || this.mScreenWidth == 0) {
                            HBRecorderCodecInfo hbRecorderCodecInfo = new HBRecorderCodecInfo();
                            hbRecorderCodecInfo.setContext((Context)this);
                            this.mScreenHeight = hbRecorderCodecInfo.getMaxSupportedHeight();
                            this.mScreenWidth = hbRecorderCodecInfo.getMaxSupportedWidth();
                        }
                        this.mScreenDensity = intent.getIntExtra("density", 1);
                        this.isVideoHD = intent.getBooleanExtra("quality", true);
                        this.isAudioEnabled = intent.getBooleanExtra("audio", true);
                        this.path = intent.getStringExtra("path");
                        this.name = intent.getStringExtra("fileName");
                        String audioSource = intent.getStringExtra("audioSource");
                        String videoEncoder = intent.getStringExtra("videoEncoder");
                        this.videoFrameRate = intent.getIntExtra("videoFrameRate", 30);
                        this.videoBitrate = intent.getIntExtra("videoBitrate", 40000000);
                        if (audioSource != null) {
                            this.setAudioSourceAsInt(audioSource);
                        }
                        if (videoEncoder != null) {
                            this.setvideoEncoderAsInt(videoEncoder);
                        }
                        filePath = this.name;
                        this.audioBitrate = intent.getIntExtra("audioBitrate", 128000);
                        this.audioSamplingRate = intent.getIntExtra("audioSamplingRate", 44100);
                        String outputFormat = intent.getStringExtra("outputFormat");
                        if (outputFormat != null) {
                            this.setOutputFormatAsInt(outputFormat);
                        }
                        this.isCustomSettingsEnabled = intent.getBooleanExtra("enableCustomSettings", false);
                        if (notificationButtonText == null) {
                            notificationButtonText = "STOP RECORDING";
                        }
                        if (this.audioBitrate == 0) {
                            this.audioBitrate = 128000;
                        }
                        if (this.audioSamplingRate == 0) {
                            this.audioSamplingRate = 44100;
                        }
                        if (notificationTitle == null || notificationTitle.equals("")) {
                            notificationTitle = this.getString(R.string.stop_recording_notification_title);
                        }
                        if (notificationDescription == null || notificationDescription.equals("")) {
                            notificationDescription = this.getString(R.string.stop_recording_notification_message);
                        }
                        if (Build.VERSION.SDK_INT >= 26) {
                            String channelId = "001";
                            String channelName = "RecordChannel";
                            NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)channelName, 0);
                            channel.setLightColor(-16776961);
                            channel.setLockscreenVisibility(0);
                            NotificationManager manager = (NotificationManager)this.getSystemService("notification");
                            if (manager != null) {
                                Notification notification;
                                manager.createNotificationChannel(channel);
                                Intent myIntent = new Intent((Context)this, NotificationReceiver.class);
                                PendingIntent pendingIntent = Build.VERSION.SDK_INT >= 31 ? PendingIntent.getBroadcast((Context)this, (int)0, (Intent)myIntent, (int)0x4000000) : PendingIntent.getBroadcast((Context)this, (int)0, (Intent)myIntent, (int)0);
                                Notification.Action action = new Notification.Action.Builder(Icon.createWithResource((Context)this, (int)17301678), (CharSequence)notificationButtonText, pendingIntent).build();
                                if (notificationSmallIcon != null) {
                                    Bitmap bmp = BitmapFactory.decodeByteArray((byte[])notificationSmallIcon, (int)0, (int)notificationSmallIcon.length);
                                    notification = new Notification.Builder(this.getApplicationContext(), channelId).setOngoing(true).setSmallIcon(Icon.createWithBitmap((Bitmap)bmp)).setContentTitle((CharSequence)notificationTitle).setContentText((CharSequence)notificationDescription).addAction(action).build();
                                } else {
                                    notification = notificationSmallVector != 0 ? new Notification.Builder(this.getApplicationContext(), channelId).setOngoing(true).setSmallIcon(notificationSmallVector).setContentTitle((CharSequence)notificationTitle).setContentText((CharSequence)notificationDescription).addAction(action).build() : new Notification.Builder(this.getApplicationContext(), channelId).setOngoing(true).setSmallIcon(R.drawable.icon).setContentTitle((CharSequence)notificationTitle).setContentText((CharSequence)notificationDescription).addAction(action).build();
                                }
                                this.startForeground(101, notification);
                            }
                        } else {
                            this.startForeground(101, new Notification());
                        }
                        if (this.returnedUri == null && this.path == null) {
                            this.path = String.valueOf(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_MOVIES));
                        }
                        try {
                            this.initRecorder();
                        }
                        catch (Exception e) {
                            receiver = (ResultReceiver)intent.getParcelableExtra(BUNDLED_LISTENER);
                            bundle = new Bundle();
                            bundle.putString("errorReason", Log.getStackTraceString((Throwable)e));
                            if (receiver == null) break block29;
                            receiver.send(-1, bundle);
                        }
                    }
                    try {
                        this.initMediaProjection();
                    }
                    catch (Exception e) {
                        receiver = (ResultReceiver)intent.getParcelableExtra(BUNDLED_LISTENER);
                        bundle = new Bundle();
                        bundle.putString("errorReason", Log.getStackTraceString((Throwable)e));
                        if (receiver == null) break block30;
                        receiver.send(-1, bundle);
                    }
                }
                try {
                    this.initVirtualDisplay();
                }
                catch (Exception e) {
                    receiver = (ResultReceiver)intent.getParcelableExtra(BUNDLED_LISTENER);
                    bundle = new Bundle();
                    bundle.putString("errorReason", Log.getStackTraceString((Throwable)e));
                    if (receiver == null) break block31;
                    receiver.send(-1, bundle);
                }
            }
            this.mMediaRecorder.setOnErrorListener(new MediaRecorder.OnErrorListener(){

                public void onError(MediaRecorder mediaRecorder, int what, int extra) {
                    if (what == 268435556 && ScreenRecordService.this.hasMaxFileBeenReached) {
                        return;
                    }
                    ResultReceiver receiver = (ResultReceiver)intent.getParcelableExtra(ScreenRecordService.BUNDLED_LISTENER);
                    Bundle bundle = new Bundle();
                    bundle.putInt("error", 38);
                    bundle.putString("errorReason", String.valueOf(what));
                    if (receiver != null) {
                        receiver.send(-1, bundle);
                    }
                }
            });
            this.mMediaRecorder.setOnInfoListener(new MediaRecorder.OnInfoListener(){

                public void onInfo(MediaRecorder mr, int what, int extra) {
                    if (what == 801) {
                        ScreenRecordService.this.hasMaxFileBeenReached = true;
                        Log.i((String)ScreenRecordService.TAG, (String)String.format(Locale.US, "onInfoListen what : %d | extra %d", what, extra));
                        ResultReceiver receiver = (ResultReceiver)intent.getParcelableExtra(ScreenRecordService.BUNDLED_LISTENER);
                        Bundle bundle = new Bundle();
                        bundle.putInt("error", 48);
                        bundle.putString("errorReason", ScreenRecordService.this.getString(R.string.max_file_reached));
                        if (receiver != null) {
                            receiver.send(-1, bundle);
                        }
                    }
                }
            });
            try {
                this.mMediaRecorder.start();
                ResultReceiver receiver2 = (ResultReceiver)intent.getParcelableExtra(BUNDLED_LISTENER);
                Bundle bundle2 = new Bundle();
                bundle2.putInt("onStart", 111);
                if (receiver2 == null) return 1;
                receiver2.send(-1, bundle2);
                return 1;
            }
            catch (Exception e) {
                receiver = (ResultReceiver)intent.getParcelableExtra(BUNDLED_LISTENER);
                bundle = new Bundle();
                bundle.putInt("error", 38);
                bundle.putString("errorReason", Log.getStackTraceString((Throwable)e));
                if (receiver == null) return 1;
                receiver.send(-1, bundle);
            }
            return 1;
        }
        this.stopSelf(startId);
        return 1;
    }

    @RequiresApi(api=24)
    private void pauseRecording() {
        this.mMediaRecorder.pause();
    }

    @RequiresApi(api=24)
    private void resumeRecording() {
        this.mMediaRecorder.resume();
    }

    private void setOutputFormatAsInt(String outputFormat) {
        switch (outputFormat) {
            case "DEFAULT": {
                this.outputFormatAsInt = 0;
                break;
            }
            case "THREE_GPP": {
                this.outputFormatAsInt = 1;
                break;
            }
            case "AMR_NB": {
                this.outputFormatAsInt = 3;
                break;
            }
            case "AMR_WB": {
                this.outputFormatAsInt = 4;
                break;
            }
            case "AAC_ADTS": {
                this.outputFormatAsInt = 6;
                break;
            }
            case "MPEG_2_TS": {
                this.outputFormatAsInt = 8;
                break;
            }
            case "WEBM": {
                this.outputFormatAsInt = 9;
                break;
            }
            case "OGG": {
                this.outputFormatAsInt = 11;
                break;
            }
            default: {
                this.outputFormatAsInt = 2;
            }
        }
    }

    private void setvideoEncoderAsInt(String encoder) {
        switch (encoder) {
            case "DEFAULT": {
                this.videoEncoderAsInt = 0;
                break;
            }
            case "H263": {
                this.videoEncoderAsInt = 1;
                break;
            }
            case "H264": {
                this.videoEncoderAsInt = 2;
                break;
            }
            case "MPEG_4_SP": {
                this.videoEncoderAsInt = 3;
                break;
            }
            case "VP8": {
                this.videoEncoderAsInt = 4;
                break;
            }
            case "HEVC": {
                this.videoEncoderAsInt = 5;
            }
        }
    }

    private void setAudioSourceAsInt(String audioSource) {
        switch (audioSource) {
            case "DEFAULT": {
                this.audioSourceAsInt = 0;
                break;
            }
            case "MIC": {
                this.audioSourceAsInt = 1;
                break;
            }
            case "VOICE_UPLINK": {
                this.audioSourceAsInt = 2;
                break;
            }
            case "VOICE_DOWNLINK": {
                this.audioSourceAsInt = 3;
                break;
            }
            case "VOICE_CALL": {
                this.audioSourceAsInt = 4;
                break;
            }
            case "CAMCODER": {
                this.audioSourceAsInt = 5;
                break;
            }
            case "VOICE_RECOGNITION": {
                this.audioSourceAsInt = 6;
                break;
            }
            case "VOICE_COMMUNICATION": {
                this.audioSourceAsInt = 7;
                break;
            }
            case "REMOTE_SUBMIX": {
                this.audioSourceAsInt = 8;
                break;
            }
            case "UNPROCESSED": {
                this.audioSourceAsInt = 9;
                break;
            }
            case "VOICE_PERFORMANCE": {
                this.audioSourceAsInt = 10;
            }
        }
    }

    @RequiresApi(api=21)
    private void initMediaProjection() {
        this.mMediaProjection = ((MediaProjectionManager)Objects.requireNonNull(this.getSystemService("media_projection"))).getMediaProjection(this.mResultCode, this.mResultData);
    }

    public static String getFilePath() {
        return filePath;
    }

    public static String getFileName() {
        return fileName;
    }

    @RequiresApi(api=21)
    private void initRecorder() throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.getDefault());
        Date curDate = new Date(System.currentTimeMillis());
        String curTime = formatter.format(curDate).replace(" ", "");
        String videoQuality = "HD";
        if (!this.isVideoHD) {
            videoQuality = "SD";
        }
        if (this.name == null) {
            this.name = videoQuality + curTime;
        }
        filePath = this.path + "/" + this.name + ".mp4";
        fileName = this.name + ".mp4";
        this.mMediaRecorder = new MediaRecorder();
        if (this.isAudioEnabled) {
            this.mMediaRecorder.setAudioSource(this.audioSourceAsInt);
        }
        this.mMediaRecorder.setVideoSource(2);
        this.mMediaRecorder.setOutputFormat(this.outputFormatAsInt);
        if (this.orientationHint != 400) {
            this.mMediaRecorder.setOrientationHint(this.orientationHint);
        }
        if (this.isAudioEnabled) {
            this.mMediaRecorder.setAudioEncoder(3);
            this.mMediaRecorder.setAudioEncodingBitRate(this.audioBitrate);
            this.mMediaRecorder.setAudioSamplingRate(this.audioSamplingRate);
        }
        this.mMediaRecorder.setVideoEncoder(this.videoEncoderAsInt);
        if (this.returnedUri != null) {
            try {
                ContentResolver contentResolver = this.getContentResolver();
                FileDescriptor inputPFD = Objects.requireNonNull(contentResolver.openFileDescriptor(this.returnedUri, "rw")).getFileDescriptor();
                this.mMediaRecorder.setOutputFile(inputPFD);
            }
            catch (Exception e) {
                ResultReceiver receiver = (ResultReceiver)this.mIntent.getParcelableExtra(BUNDLED_LISTENER);
                Bundle bundle = new Bundle();
                bundle.putString("errorReason", Log.getStackTraceString((Throwable)e));
                if (receiver != null) {
                    receiver.send(-1, bundle);
                }
            }
        } else {
            this.mMediaRecorder.setOutputFile(filePath);
        }
        this.mMediaRecorder.setVideoSize(this.mScreenWidth, this.mScreenHeight);
        if (!this.isCustomSettingsEnabled) {
            if (!this.isVideoHD) {
                this.mMediaRecorder.setVideoEncodingBitRate(12000000);
                this.mMediaRecorder.setVideoFrameRate(30);
            } else {
                this.mMediaRecorder.setVideoEncodingBitRate(5 * this.mScreenWidth * this.mScreenHeight);
                this.mMediaRecorder.setVideoFrameRate(60);
            }
        } else {
            this.mMediaRecorder.setVideoEncodingBitRate(this.videoBitrate);
            this.mMediaRecorder.setVideoFrameRate(this.videoFrameRate);
        }
        if (this.maxFileSize > 0L) {
            this.mMediaRecorder.setMaxFileSize(this.maxFileSize);
        }
        this.mMediaRecorder.prepare();
    }

    @RequiresApi(api=21)
    private void initVirtualDisplay() {
        this.mVirtualDisplay = this.mMediaProjection.createVirtualDisplay(TAG, this.mScreenWidth, this.mScreenHeight, this.mScreenDensity, 16, this.mMediaRecorder.getSurface(), null, null);
    }

    @RequiresApi(api=21)
    public void onDestroy() {
        super.onDestroy();
        this.resetAll();
        this.callOnComplete();
    }

    private void callOnComplete() {
        if (this.mIntent != null) {
            ResultReceiver receiver = (ResultReceiver)this.mIntent.getParcelableExtra(BUNDLED_LISTENER);
            Bundle bundle = new Bundle();
            bundle.putString("onComplete", "Uri was passed");
            if (receiver != null) {
                receiver.send(-1, bundle);
            }
        }
    }

    @RequiresApi(api=21)
    private void resetAll() {
        this.stopForeground(true);
        if (this.mVirtualDisplay != null) {
            this.mVirtualDisplay.release();
            this.mVirtualDisplay = null;
        }
        if (this.mMediaRecorder != null) {
            this.mMediaRecorder.setOnErrorListener(null);
            this.mMediaRecorder.reset();
        }
        if (this.mMediaProjection != null) {
            this.mMediaProjection.stop();
            this.mMediaProjection = null;
        }
    }

    public IBinder onBind(Intent intent) {
        return null;
    }
}

