/*
 * Decompiled with CFR 0.152.
 */
package com.hbisoft.hbrecorder;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.DisplayMetrics;
import android.util.Log;
import androidx.annotation.DrawableRes;
import androidx.annotation.RequiresApi;
import com.hbisoft.hbrecorder.Countdown;
import com.hbisoft.hbrecorder.FileObserver;
import com.hbisoft.hbrecorder.HBRecorderCodecInfo;
import com.hbisoft.hbrecorder.HBRecorderListener;
import com.hbisoft.hbrecorder.MyListener;
import com.hbisoft.hbrecorder.ScreenRecordService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;

@RequiresApi(api=21)
public class HBRecorder
implements MyListener {
    private int mScreenWidth;
    private int mScreenHeight;
    private int mScreenDensity;
    private final Context context;
    private int resultCode;
    private boolean isAudioEnabled = true;
    private boolean isVideoHDEnabled = true;
    private Activity activity;
    private String outputPath;
    private String fileName;
    private String notificationTitle;
    private String notificationDescription;
    private String notificationButtonText;
    private int audioBitrate = 0;
    private int audioSamplingRate = 0;
    private FileObserver observer;
    private final HBRecorderListener hbRecorderListener;
    private byte[] byteArray;
    private String audioSource = "MIC";
    private String videoEncoder = "DEFAULT";
    private boolean enableCustomSettings = false;
    private int videoFrameRate = 30;
    private int videoBitrate = 40000000;
    private String outputFormat = "DEFAULT";
    private int orientation;
    private long maxFileSize = 0L;
    boolean wasOnErrorCalled = false;
    Intent service;
    boolean isPaused = false;
    boolean isMaxDurationSet = false;
    int maxDuration = 0;
    Uri mUri;
    boolean mWasUriSet = false;
    Countdown countDown = null;

    @RequiresApi(api=21)
    public HBRecorder(Context context, HBRecorderListener listener) {
        this.context = context.getApplicationContext();
        this.hbRecorderListener = listener;
        this.setScreenDensity();
    }

    public void setOrientationHint(int orientationInDegrees) {
        this.orientation = orientationInDegrees;
    }

    public void setOutputPath(String path) {
        this.outputPath = path;
    }

    @RequiresApi(api=29)
    public void setOutputUri(Uri uri) {
        this.mWasUriSet = true;
        this.mUri = uri;
    }

    public void setMaxDuration(int seconds) {
        this.isMaxDurationSet = true;
        this.maxDuration = seconds * 1000;
    }

    public void setMaxFileSize(long fileSize) {
        this.maxFileSize = fileSize;
    }

    public boolean wasUriSet() {
        return this.mWasUriSet;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setAudioBitrate(int audioBitrate) {
        this.audioBitrate = audioBitrate;
    }

    public void setAudioSamplingRate(int audioSamplingRate) {
        this.audioSamplingRate = audioSamplingRate;
    }

    public void isAudioEnabled(boolean bool) {
        this.isAudioEnabled = bool;
    }

    public void setAudioSource(String source) {
        this.audioSource = source;
    }

    public void recordHDVideo(boolean bool) {
        this.isVideoHDEnabled = bool;
    }

    public void setVideoEncoder(String encoder) {
        this.videoEncoder = encoder;
    }

    public void enableCustomSettings() {
        this.enableCustomSettings = true;
    }

    public void setVideoFrameRate(int fps) {
        this.videoFrameRate = fps;
    }

    public void setVideoBitrate(int bitrate) {
        this.videoBitrate = bitrate;
    }

    public void setOutputFormat(String format) {
        this.outputFormat = format;
    }

    private void setScreenDensity() {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        this.mScreenDensity = metrics.densityDpi;
    }

    public int getDefaultWidth() {
        HBRecorderCodecInfo hbRecorderCodecInfo = new HBRecorderCodecInfo();
        hbRecorderCodecInfo.setContext(this.context);
        return hbRecorderCodecInfo.getMaxSupportedWidth();
    }

    public int getDefaultHeight() {
        HBRecorderCodecInfo hbRecorderCodecInfo = new HBRecorderCodecInfo();
        hbRecorderCodecInfo.setContext(this.context);
        return hbRecorderCodecInfo.getMaxSupportedHeight();
    }

    public void setScreenDimensions(int heightInPX, int widthInPX) {
        this.mScreenHeight = heightInPX;
        this.mScreenWidth = widthInPX;
    }

    public String getFilePath() {
        return ScreenRecordService.getFilePath();
    }

    public String getFileName() {
        return ScreenRecordService.getFileName();
    }

    public void startScreenRecording(Intent data, int resultCode, Activity activity) {
        this.resultCode = resultCode;
        this.activity = activity;
        this.startService(data);
    }

    public void stopScreenRecording() {
        Intent service = new Intent(this.context, ScreenRecordService.class);
        this.context.stopService(service);
    }

    @RequiresApi(api=24)
    public void pauseScreenRecording() {
        if (this.service != null) {
            this.isPaused = true;
            this.service.setAction("pause");
            this.context.startService(this.service);
        }
    }

    @RequiresApi(api=24)
    public void resumeScreenRecording() {
        if (this.service != null) {
            this.isPaused = false;
            this.service.setAction("resume");
            this.context.startService(this.service);
        }
    }

    public boolean isRecordingPaused() {
        return this.isPaused;
    }

    public boolean isBusyRecording() {
        ActivityManager manager = (ActivityManager)this.context.getSystemService("activity");
        if (manager != null) {
            for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
                if (!ScreenRecordService.class.getName().equals(service.service.getClassName())) continue;
                return true;
            }
        }
        return false;
    }

    public void setNotificationSmallIcon(@DrawableRes int drawable2) {
        Bitmap icon = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)drawable2);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        icon.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        this.byteArray = stream.toByteArray();
    }

    public void setNotificationSmallIcon(byte[] bytes) {
        this.byteArray = bytes;
    }

    public void setNotificationTitle(String Title) {
        this.notificationTitle = Title;
    }

    public void setNotificationDescription(String Description) {
        this.notificationDescription = Description;
    }

    public void setNotificationButtonText(String string2) {
        this.notificationButtonText = string2;
    }

    private void startService(Intent data) {
        try {
            if (!this.mWasUriSet) {
                if (this.outputPath != null) {
                    File file = new File(this.outputPath);
                    String parent = file.getParent();
                    this.observer = new FileObserver(parent, this.activity, this);
                } else {
                    this.observer = new FileObserver(String.valueOf(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_MOVIES)), this.activity, this);
                }
                this.observer.startWatching();
            }
            this.service = new Intent(this.context, ScreenRecordService.class);
            if (this.mWasUriSet) {
                this.service.putExtra("mUri", this.mUri.toString());
            }
            this.service.putExtra("code", this.resultCode);
            this.service.putExtra("data", (Parcelable)data);
            this.service.putExtra("audio", this.isAudioEnabled);
            this.service.putExtra("width", this.mScreenWidth);
            this.service.putExtra("height", this.mScreenHeight);
            this.service.putExtra("density", this.mScreenDensity);
            this.service.putExtra("quality", this.isVideoHDEnabled);
            this.service.putExtra("path", this.outputPath);
            this.service.putExtra("fileName", this.fileName);
            this.service.putExtra("orientation", this.orientation);
            this.service.putExtra("audioBitrate", this.audioBitrate);
            this.service.putExtra("audioSamplingRate", this.audioSamplingRate);
            this.service.putExtra("notificationSmallBitmap", this.byteArray);
            this.service.putExtra("notificationTitle", this.notificationTitle);
            this.service.putExtra("notificationDescription", this.notificationDescription);
            this.service.putExtra("notificationButtonText", this.notificationButtonText);
            this.service.putExtra("enableCustomSettings", this.enableCustomSettings);
            this.service.putExtra("audioSource", this.audioSource);
            this.service.putExtra("videoEncoder", this.videoEncoder);
            this.service.putExtra("videoFrameRate", this.videoFrameRate);
            this.service.putExtra("videoBitrate", this.videoBitrate);
            this.service.putExtra("outputFormat", this.outputFormat);
            this.service.putExtra("listener", (Parcelable)new ResultReceiver(new Handler()){

                protected void onReceiveResult(int resultCode, Bundle resultData) {
                    super.onReceiveResult(resultCode, resultData);
                    if (resultCode == -1) {
                        String errorListener = resultData.getString("errorReason");
                        String onComplete = resultData.getString("onComplete");
                        int onStartCode = resultData.getInt("onStart");
                        int errorCode = resultData.getInt("error");
                        if (errorListener != null) {
                            HBRecorder.this.stopCountDown();
                            if (!HBRecorder.this.mWasUriSet) {
                                HBRecorder.this.observer.stopWatching();
                            }
                            HBRecorder.this.wasOnErrorCalled = true;
                            if (errorCode > 0) {
                                HBRecorder.this.hbRecorderListener.HBRecorderOnError(errorCode, errorListener);
                            } else {
                                HBRecorder.this.hbRecorderListener.HBRecorderOnError(100, errorListener);
                            }
                            try {
                                Intent mService = new Intent(HBRecorder.this.context, ScreenRecordService.class);
                                HBRecorder.this.context.stopService(mService);
                            }
                            catch (Exception exception) {}
                        } else if (onComplete != null) {
                            HBRecorder.this.stopCountDown();
                            if (HBRecorder.this.mWasUriSet && !HBRecorder.this.wasOnErrorCalled) {
                                HBRecorder.this.hbRecorderListener.HBRecorderOnComplete();
                            }
                            HBRecorder.this.wasOnErrorCalled = false;
                        } else if (onStartCode != 0) {
                            HBRecorder.this.hbRecorderListener.HBRecorderOnStart();
                            if (HBRecorder.this.isMaxDurationSet) {
                                HBRecorder.this.startCountdown();
                            }
                        }
                    }
                }
            });
            this.service.putExtra("maxFileSize", this.maxFileSize);
            this.context.startService(this.service);
        }
        catch (Exception e) {
            this.hbRecorderListener.HBRecorderOnError(0, Log.getStackTraceString((Throwable)e));
        }
    }

    private void startCountdown() {
        this.countDown = new Countdown(this.maxDuration, 1000L, 0L){

            @Override
            public void onTick(long timeLeft) {
            }

            @Override
            public void onFinished() {
                this.onTick(0L);
                HBRecorder.this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HBRecorder.this.stopScreenRecording();
                            HBRecorder.this.observer.stopWatching();
                            HBRecorder.this.hbRecorderListener.HBRecorderOnComplete();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }

            @Override
            public void onStopCalled() {
            }
        };
        this.countDown.start();
    }

    private void stopCountDown() {
        if (this.countDown != null) {
            this.countDown.stop();
        }
    }

    @Override
    public void callback() {
        this.observer.stopWatching();
        this.hbRecorderListener.HBRecorderOnComplete();
    }
}

