/*
 * Decompiled with CFR 0.152.
 */
package com.hbisoft.hbrecorder;

import android.content.Context;
import android.content.res.Configuration;
import android.media.CamcorderProfile;
import android.util.DisplayMetrics;
import android.view.WindowManager;

public class HBRecorderCodecInfo {
    private Context context;

    int getMaxSupportedWidth() {
        RecordingInfo recordingInfo = this.getRecordingInfo();
        return recordingInfo.width;
    }

    int getMaxSupportedHeight() {
        RecordingInfo recordingInfo = this.getRecordingInfo();
        return recordingInfo.height;
    }

    private RecordingInfo getRecordingInfo() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        wm.getDefaultDisplay().getRealMetrics(displayMetrics);
        int displayWidth = displayMetrics.widthPixels;
        int displayHeight = displayMetrics.heightPixels;
        int displayDensity = displayMetrics.densityDpi;
        Configuration configuration = this.context.getResources().getConfiguration();
        boolean isLandscape = configuration.orientation == 2;
        CamcorderProfile camcorderProfile = CamcorderProfile.get((int)1);
        int cameraWidth = camcorderProfile != null ? camcorderProfile.videoFrameWidth : -1;
        int cameraHeight = camcorderProfile != null ? camcorderProfile.videoFrameHeight : -1;
        int cameraFrameRate = camcorderProfile != null ? camcorderProfile.videoFrameRate : 30;
        return HBRecorderCodecInfo.calculateRecordingInfo(displayWidth, displayHeight, displayDensity, isLandscape, cameraWidth, cameraHeight, cameraFrameRate, 100);
    }

    public void setContext(Context c) {
        this.context = c;
    }

    static RecordingInfo calculateRecordingInfo(int displayWidth, int displayHeight, int displayDensity, boolean isLandscapeDevice, int cameraWidth, int cameraHeight, int cameraFrameRate, int sizePercentage) {
        int frameHeight;
        displayWidth = displayWidth * sizePercentage / 100;
        displayHeight = displayHeight * sizePercentage / 100;
        if (cameraWidth == -1 && cameraHeight == -1) {
            return new RecordingInfo(displayWidth, displayHeight, cameraFrameRate, displayDensity);
        }
        int frameWidth = isLandscapeDevice ? cameraWidth : cameraHeight;
        int n = frameHeight = isLandscapeDevice ? cameraHeight : cameraWidth;
        if (frameWidth >= displayWidth && frameHeight >= displayHeight) {
            return new RecordingInfo(displayWidth, displayHeight, cameraFrameRate, displayDensity);
        }
        if (isLandscapeDevice) {
            frameWidth = displayWidth * frameHeight / displayHeight;
        } else {
            frameHeight = displayHeight * frameWidth / displayWidth;
        }
        return new RecordingInfo(frameWidth, frameHeight, cameraFrameRate, displayDensity);
    }

    static final class RecordingInfo {
        final int width;
        final int height;
        final int frameRate;
        final int density;

        RecordingInfo(int width, int height, int frameRate, int density) {
            this.width = width;
            this.height = height;
            this.frameRate = frameRate;
            this.density = density;
        }
    }
}

