/*
 * Decompiled with CFR 0.152.
 */
package com.hbisoft.hbrecorder;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.DisplayMetrics;
import androidx.annotation.RequiresApi;
import com.hbisoft.hbrecorder.FileObserver;
import com.hbisoft.hbrecorder.HBRecorderListener;
import com.hbisoft.hbrecorder.MyListener;
import com.hbisoft.hbrecorder.ScreenRecordService;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

@RequiresApi(api=21)
public class HBRecorder
implements MyListener {
    private int mScreenWidth;
    private int mScreenHeight;
    private int mScreenDensity;
    private final Context context;
    private int resultCode;
    private boolean isAudioEnabled = true;
    private boolean isVideoHDEnabled = true;
    private Activity activity;
    private String outputPath;
    private String fileName;
    private String notificationTitle;
    private String notificationDescription;
    private String notificationButtonText;
    private int audioBitrate = 0;
    private int audioSamplingRate = 0;
    private FileObserver observer;
    private final HBRecorderListener hbRecorderListener;
    private byte[] byteArray;
    private boolean shouldShowNotification = false;
    private String audioSource = "MIC";
    private String videoEncoder = "DEFAULT";
    private boolean enableCustomSettings = false;
    private int videoFrameRate = 30;
    private int videoBitrate = 40000000;
    private String outputFormat = "DEFAULT";

    @RequiresApi(api=21)
    public HBRecorder(Context context, HBRecorderListener listener) {
        this.context = context.getApplicationContext();
        this.hbRecorderListener = listener;
        this.setScreenDensity();
    }

    public void setOutputPath(String path) {
        this.outputPath = path;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setAudioBitrate(int audioBitrate) {
        this.audioBitrate = audioBitrate;
    }

    public void setAudioSamplingRate(int audioSamplingRate) {
        this.audioSamplingRate = audioSamplingRate;
    }

    public void isAudioEnabled(boolean bool) {
        this.isAudioEnabled = bool;
    }

    public void setAudioSource(String source) {
        this.audioSource = source;
    }

    public void recordHDVideo(boolean bool) {
        this.isVideoHDEnabled = bool;
    }

    public void setVideoEncoder(String encoder) {
        this.videoEncoder = encoder;
    }

    public void enableCustomSettings() {
        this.enableCustomSettings = true;
    }

    public void setVideoFrameRate(int fps) {
        this.videoFrameRate = fps;
    }

    public void setVideoBitrate(int bitrate) {
        this.videoBitrate = bitrate;
    }

    public void setOutputFormat(String format) {
        this.outputFormat = format;
    }

    private void setScreenDensity() {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        this.mScreenDensity = metrics.densityDpi;
    }

    public void setScreenDimensions(int heightInPX, int widthInPX) {
        this.mScreenHeight = heightInPX;
        this.mScreenWidth = widthInPX;
    }

    public String getFilePath() {
        return ScreenRecordService.getFilePath();
    }

    public String getFileName() {
        return ScreenRecordService.getFileName();
    }

    public void startScreenRecording(Intent data, int resultCode, Activity activity) {
        this.resultCode = resultCode;
        this.activity = activity;
        this.startService(data);
    }

    public void stopScreenRecording() {
        Intent service = new Intent(this.context, ScreenRecordService.class);
        this.context.stopService(service);
    }

    public boolean isBusyRecording() {
        ActivityManager manager = (ActivityManager)this.context.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!ScreenRecordService.class.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public void setNotificationSmallIcon(int drawable2) {
        Bitmap icon = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)drawable2);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        icon.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        this.byteArray = stream.toByteArray();
    }

    public void shouldShowNotification(boolean bool) {
        this.shouldShowNotification = bool;
    }

    public void setNotificationTitle(String Title) {
        this.notificationTitle = Title;
    }

    public void setNotificationDescription(String Description) {
        this.notificationDescription = Description;
    }

    public void setNotificationButtonText(String string) {
        this.notificationButtonText = string;
    }

    private void startService(Intent data) {
        this.observer = new FileObserver(String.valueOf(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_MOVIES)), this.activity, this);
        this.observer.startWatching();
        Intent service = new Intent(this.context, ScreenRecordService.class);
        service.putExtra("code", this.resultCode);
        service.putExtra("data", (Parcelable)data);
        service.putExtra("audio", this.isAudioEnabled);
        service.putExtra("width", this.mScreenWidth);
        service.putExtra("height", this.mScreenHeight);
        service.putExtra("density", this.mScreenDensity);
        service.putExtra("quality", this.isVideoHDEnabled);
        service.putExtra("path", this.outputPath);
        service.putExtra("fileName", this.fileName);
        service.putExtra("audioBitrate", this.audioBitrate);
        service.putExtra("audioSamplingRate", this.audioSamplingRate);
        service.putExtra("notificationSmallBitmap", this.byteArray);
        service.putExtra("notificationTitle", this.notificationTitle);
        service.putExtra("notificationDescription", this.notificationDescription);
        service.putExtra("shouldShowNotification", this.shouldShowNotification);
        service.putExtra("notificationButtonText", this.notificationButtonText);
        service.putExtra("enableCustomSettings", this.enableCustomSettings);
        service.putExtra("audioSource", this.audioSource);
        service.putExtra("videoEncoder", this.videoEncoder);
        service.putExtra("videoFrameRate", this.videoFrameRate);
        service.putExtra("videoBitrate", this.videoBitrate);
        service.putExtra("outputFormat", this.outputFormat);
        service.putExtra("listener", (Parcelable)new ResultReceiver(new Handler()){

            protected void onReceiveResult(int resultCode, Bundle resultData) {
                String result;
                super.onReceiveResult(resultCode, resultData);
                if (resultCode == -1 && (result = resultData.getString("errorReason")) != null) {
                    HBRecorder.this.observer.stopWatching();
                    HBRecorder.this.hbRecorderListener.HBRecorderOnError(100, result);
                    Intent mservice = new Intent(HBRecorder.this.context, ScreenRecordService.class);
                    HBRecorder.this.context.stopService(mservice);
                }
            }
        });
        this.context.startService(service);
    }

    @Override
    public void callback() {
        this.observer.stopWatching();
        this.hbRecorderListener.HBRecorderOnComplete();
    }
}

