/*
 * Decompiled with CFR 0.152.
 */
package com.hbisoft.hbrecorder;

import android.content.Context;
import android.content.res.Configuration;
import android.media.CamcorderProfile;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.util.DisplayMetrics;
import android.util.Range;
import android.view.WindowManager;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.HashMap;

public class HBRecorderCodecInfo {
    private Context context;
    ArrayList<String> supportedVideoFormats = new ArrayList();
    ArrayList<String> supportedAudioFormats = new ArrayList();
    HashMap<String, String> mVideoMap = new HashMap();
    HashMap<String, String> mAudioMap = new HashMap();

    int getMaxSupportedWidth() {
        RecordingInfo recordingInfo = this.getRecordingInfo();
        return recordingInfo.width;
    }

    int getMaxSupportedHeight() {
        RecordingInfo recordingInfo = this.getRecordingInfo();
        return recordingInfo.height;
    }

    private RecordingInfo getRecordingInfo() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        wm.getDefaultDisplay().getRealMetrics(displayMetrics);
        int displayWidth = displayMetrics.widthPixels;
        int displayHeight = displayMetrics.heightPixels;
        int displayDensity = displayMetrics.densityDpi;
        Configuration configuration = this.context.getResources().getConfiguration();
        boolean isLandscape = configuration.orientation == 2;
        CamcorderProfile camcorderProfile = CamcorderProfile.get((int)1);
        int cameraWidth = camcorderProfile != null ? camcorderProfile.videoFrameWidth : -1;
        int cameraHeight = camcorderProfile != null ? camcorderProfile.videoFrameHeight : -1;
        int cameraFrameRate = camcorderProfile != null ? camcorderProfile.videoFrameRate : 30;
        return HBRecorderCodecInfo.calculateRecordingInfo(displayWidth, displayHeight, displayDensity, isLandscape, cameraWidth, cameraHeight, cameraFrameRate, 100);
    }

    public void setContext(Context c) {
        this.context = c;
    }

    static RecordingInfo calculateRecordingInfo(int displayWidth, int displayHeight, int displayDensity, boolean isLandscapeDevice, int cameraWidth, int cameraHeight, int cameraFrameRate, int sizePercentage) {
        int frameHeight;
        displayWidth = displayWidth * sizePercentage / 100;
        displayHeight = displayHeight * sizePercentage / 100;
        if (cameraWidth == -1 && cameraHeight == -1) {
            return new RecordingInfo(displayWidth, displayHeight, cameraFrameRate, displayDensity);
        }
        int frameWidth = isLandscapeDevice ? cameraWidth : cameraHeight;
        int n = frameHeight = isLandscapeDevice ? cameraHeight : cameraWidth;
        if (frameWidth >= displayWidth && frameHeight >= displayHeight) {
            return new RecordingInfo(displayWidth, displayHeight, cameraFrameRate, displayDensity);
        }
        if (isLandscapeDevice) {
            frameWidth = displayWidth * frameHeight / displayHeight;
        } else {
            frameHeight = displayHeight * frameWidth / displayWidth;
        }
        return new RecordingInfo(frameWidth, frameHeight, cameraFrameRate, displayDensity);
    }

    public final MediaCodecInfo selectVideoCodec(String mimeType) {
        MediaCodecInfo result = null;
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            String[] types;
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!codecInfo.isEncoder()) continue;
            for (String type : types = codecInfo.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mimeType)) continue;
                return codecInfo;
            }
        }
        return result;
    }

    private String selectCodecByMime(String mimeType) {
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            String[] types;
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!codecInfo.isEncoder()) continue;
            for (String type : types = codecInfo.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mimeType)) continue;
                return codecInfo.getName();
            }
        }
        return "Mime not supported";
    }

    @RequiresApi(api=21)
    private MediaCodecInfo selectDefaultCodec() {
        MediaCodecInfo result = null;
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                MediaCodecInfo.CodecCapabilities codecCapabilities;
                boolean formatSup;
                if (!types[j].contains("video") || !(formatSup = (codecCapabilities = codecInfo.getCapabilitiesForType(types[j])).isFormatSupported(codecCapabilities.getDefaultFormat()))) continue;
                return codecInfo;
            }
        }
        return result;
    }

    public String getDefaultVideoEncoderName(String mimeType) {
        String defaultEncoder = "";
        try {
            defaultEncoder = this.selectCodecByMime(mimeType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultEncoder;
    }

    @RequiresApi(api=21)
    public String getDefaultVideoFormat() {
        String supported = "";
        try {
            MediaCodecInfo codecInfo = this.selectDefaultCodec();
            if (codecInfo != null) {
                String[] types;
                for (String type : types = codecInfo.getSupportedTypes()) {
                    if (!type.contains("video")) continue;
                    MediaCodecInfo.CodecCapabilities codecCapabilities = codecInfo.getCapabilitiesForType(type);
                    String result = codecCapabilities.getDefaultFormat().toString();
                    return this.returnTypeFromMime(result.substring(result.indexOf("=") + 1, result.indexOf(",")));
                }
            } else {
                supported = "null";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return supported;
    }

    private String returnTypeFromMime(String mimeType) {
        switch (mimeType) {
            case "video/MP2T": {
                return "MPEG_2_TS";
            }
            case "video/mp4v-es": {
                return "MPEG_4";
            }
            case "video/mp4v": {
                return "MPEG_4";
            }
            case "video/mp4": {
                return "MPEG_4";
            }
            case "video/avc": {
                return "MPEG_4";
            }
            case "video/3gpp": {
                return "THREE_GPP";
            }
            case "video/webm": {
                return "WEBM";
            }
            case "video/x-vnd.on2.vp8": {
                return "WEBM";
            }
        }
        return "";
    }

    @RequiresApi(api=21)
    public boolean isSizeAndFramerateSupported(int width, int height, int fps, String mimeType, int orientation) {
        boolean supported = false;
        try {
            String[] types;
            MediaCodecInfo codecInfo = this.selectVideoCodec(mimeType);
            for (String type : types = codecInfo.getSupportedTypes()) {
                if (!type.contains("video")) continue;
                MediaCodecInfo.CodecCapabilities codecCapabilities = codecInfo.getCapabilitiesForType(type);
                MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
                supported = 1 == orientation ? videoCapabilities.areSizeAndRateSupported(height, width, (double)fps) : videoCapabilities.areSizeAndRateSupported(width, height, (double)fps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return supported;
    }

    public boolean isMimeTypeSupported(String mimeType) {
        try {
            String[] types;
            MediaCodecInfo codecInfo = this.selectVideoCodec(mimeType);
            for (String type : types = codecInfo.getSupportedTypes()) {
                if (!type.contains("video")) continue;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @RequiresApi(api=21)
    public boolean isSizeSupported(int width, int height, String mimeType) {
        boolean supported = false;
        try {
            String[] types;
            MediaCodecInfo codecInfo = this.selectVideoCodec(mimeType);
            for (String type : types = codecInfo.getSupportedTypes()) {
                if (!type.contains("video")) continue;
                MediaCodecInfo.CodecCapabilities codecCapabilities = codecInfo.getCapabilitiesForType(type);
                MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
                supported = videoCapabilities.isSizeSupported(height, width);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return supported;
    }

    @RequiresApi(api=21)
    public double getMaxSupportedFrameRate(int width, int height, String mimeType) {
        double maxFPS = 0.0;
        try {
            String[] types;
            MediaCodecInfo codecInfo = this.selectVideoCodec(mimeType);
            for (String type : types = codecInfo.getSupportedTypes()) {
                if (!type.contains("video")) continue;
                MediaCodecInfo.CodecCapabilities codecCapabilities = codecInfo.getCapabilitiesForType(type);
                MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
                Range bit = videoCapabilities.getSupportedFrameRatesFor(height, width);
                maxFPS = (Double)bit.getUpper();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return maxFPS;
    }

    @RequiresApi(api=21)
    public int getMaxSupportedBitrate(String mimeType) {
        int bitrate = 0;
        try {
            String[] types;
            MediaCodecInfo codecInfo = this.selectVideoCodec(mimeType);
            for (String type : types = codecInfo.getSupportedTypes()) {
                if (!type.contains("video")) continue;
                MediaCodecInfo.CodecCapabilities codecCapabilities = codecInfo.getCapabilitiesForType(type);
                MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
                Range bit = videoCapabilities.getBitrateRange();
                bitrate = (Integer)bit.getUpper();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitrate;
    }

    public ArrayList<String> getSupportedVideoFormats() {
        String[] allFormats;
        for (String allFormat : allFormats = new String[]{"video/MP2T", "video/mp4v-es", "video/m4v", "video/mp4", "video/avc", "video/3gpp", "video/webm", "video/x-vnd.on2.vp8"}) {
            this.checkSupportedVideoFormats(allFormat);
        }
        return this.supportedVideoFormats;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkSupportedVideoFormats(String mimeType) {
        int numCodecs = MediaCodecList.getCodecCount();
        int i = 0;
        while (i < numCodecs) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (codecInfo.isEncoder()) {
                String[] types = codecInfo.getSupportedTypes();
                int j = 0;
                while (j < types.length) {
                    if (types[j].contains("video")) {
                        switch (mimeType) {
                            case "video/MP2T": {
                                this.supportedVideoFormats.add("MPEG_2_TS");
                                return;
                            }
                            case "video/mp4v-es": {
                                if (this.supportedVideoFormats.contains("MPEG_4")) return;
                                this.supportedVideoFormats.add("MPEG_4");
                                return;
                            }
                            case "video/mp4v": {
                                if (this.supportedVideoFormats.contains("MPEG_4")) return;
                                this.supportedVideoFormats.add("MPEG_4");
                                return;
                            }
                            case "video/mp4": {
                                if (this.supportedVideoFormats.contains("MPEG_4")) return;
                                this.supportedVideoFormats.add("MPEG_4");
                                return;
                            }
                            case "video/avc": {
                                if (this.supportedVideoFormats.contains("MPEG_4")) return;
                                this.supportedVideoFormats.add("MPEG_4");
                                return;
                            }
                            case "video/3gpp": {
                                this.supportedVideoFormats.add("THREE_GPP");
                                return;
                            }
                            case "video/webm": {
                                if (this.supportedVideoFormats.contains("WEBM")) return;
                                this.supportedVideoFormats.add("WEBM");
                                return;
                            }
                            case "video/video/x-vnd.on2.vp8": {
                                if (this.supportedVideoFormats.contains("WEBM")) return;
                                this.supportedVideoFormats.add("WEBM");
                                return;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public ArrayList<String> getSupportedAudioFormats() {
        String[] allFormats;
        for (String allFormat : allFormats = new String[]{"audio/amr_nb", "audio/amr_wb", "audio/x-hx-aac-adts", "audio/ogg"}) {
            this.checkSupportedAudioFormats(allFormat);
        }
        return this.supportedAudioFormats;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkSupportedAudioFormats(String mimeType) {
        int numCodecs = MediaCodecList.getCodecCount();
        int i = 0;
        while (i < numCodecs) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (codecInfo.isEncoder()) {
                String[] types = codecInfo.getSupportedTypes();
                int j = 0;
                while (j < types.length) {
                    if (types[j].contains("audio")) {
                        switch (mimeType) {
                            case "audio/amr_nb": {
                                this.supportedAudioFormats.add("AMR_NB");
                                return;
                            }
                            case "audio/amr_wb": {
                                this.supportedAudioFormats.add("AMR_WB");
                                return;
                            }
                            case "audio/x-hx-aac-adts": {
                                this.supportedAudioFormats.add("AAC_ADTS");
                                return;
                            }
                            case "audio/ogg": {
                                this.supportedAudioFormats.add("OGG");
                                return;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public HashMap<String, String> getSupportedVideoMimeTypes() {
        this.checkIfSupportedVideoMimeTypes();
        return this.mVideoMap;
    }

    private void checkIfSupportedVideoMimeTypes() {
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            String[] types;
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!codecInfo.isEncoder()) continue;
            for (String type : types = codecInfo.getSupportedTypes()) {
                if (!type.contains("video")) continue;
                this.mVideoMap.put(codecInfo.getName(), type);
            }
        }
    }

    public HashMap<String, String> getSupportedAudioMimeTypes() {
        this.checkIfSupportedAudioMimeTypes();
        return this.mAudioMap;
    }

    private void checkIfSupportedAudioMimeTypes() {
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            String[] types;
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!codecInfo.isEncoder()) continue;
            for (String type : types = codecInfo.getSupportedTypes()) {
                if (!type.contains("audio")) continue;
                this.mAudioMap.put(codecInfo.getName(), type);
            }
        }
    }

    static final class RecordingInfo {
        final int width;
        final int height;
        final int frameRate;
        final int density;

        RecordingInfo(int width, int height, int frameRate, int density) {
            this.width = width;
            this.height = height;
            this.frameRate = frameRate;
            this.density = density;
        }
    }
}

