/*
 * Decompiled with CFR 0.152.
 */
package com.hbisoft.hbrecorder;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import androidx.annotation.RequiresApi;
import com.hbisoft.hbrecorder.FileObserver;
import com.hbisoft.hbrecorder.HBRecorderListener;
import com.hbisoft.hbrecorder.MyListener;
import com.hbisoft.hbrecorder.ScreenRecordService;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

@RequiresApi(api=21)
public class HBRecorder
implements MyListener {
    private int mScreenWidth;
    private int mScreenHeight;
    private int mScreenDensity;
    private final Context context;
    private int resultCode;
    private Intent data;
    private boolean isAudioEnabled = true;
    private boolean isVideoHDEnabled = true;
    private Activity activity;
    private String outputPath;
    private String fileName;
    private String notificationTitle;
    private String notificationDescription;
    private String notificationButtonText;
    private int audioBitrate;
    private int audioSamplingRate;
    private FileObserver observer;
    private final HBRecorderListener hbRecorderListener;
    private byte[] byteArray;
    private boolean shouldShowNotification = false;

    @RequiresApi(api=21)
    public HBRecorder(Context context, HBRecorderListener listener) {
        this.context = context.getApplicationContext();
        this.hbRecorderListener = listener;
        this.getScreenDimensions();
    }

    public void onActivityResult(int resultCode, Intent data, Activity activity) {
        this.resultCode = resultCode;
        this.data = data;
        this.activity = activity;
    }

    public void setOutputPath(String path) {
        this.outputPath = path;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setAudioBitrate(int audioBitrate) {
        this.audioBitrate = audioBitrate;
    }

    public void setAudioSamplingRate(int audioSamplingRate) {
        this.audioSamplingRate = audioSamplingRate;
    }

    public void isAudioEnabled(boolean bool) {
        this.isAudioEnabled = bool;
    }

    public void recordHDVideo(boolean bool) {
        this.isVideoHDEnabled = bool;
    }

    private void getScreenDimensions() {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        this.mScreenWidth = metrics.widthPixels;
        this.mScreenHeight = metrics.heightPixels;
        this.mScreenDensity = metrics.densityDpi;
    }

    public String getFilePath() {
        return ScreenRecordService.getFilePath();
    }

    public String getFileName() {
        return ScreenRecordService.getFileName();
    }

    public void startScreenRecording(Intent data) {
        this.startService(data);
    }

    public void stopScreenRecording() {
        Intent service = new Intent(this.context, ScreenRecordService.class);
        this.context.stopService(service);
    }

    public boolean isBusyRecording() {
        ActivityManager manager = (ActivityManager)this.context.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!ScreenRecordService.class.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public void setNotificationSmallIcon(int drawable2) {
        Bitmap icon = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)drawable2);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        icon.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        this.byteArray = stream.toByteArray();
    }

    public void shouldShowNotification(boolean bool) {
        this.shouldShowNotification = bool;
    }

    public void setNotificationTitle(String Title) {
        this.notificationTitle = Title;
    }

    public void setNotificationDescription(String Description) {
        this.notificationDescription = Description;
    }

    public void setNotificationButtonText(String string) {
        this.notificationButtonText = string;
    }

    private void startService(Intent data) {
        this.observer = new FileObserver(String.valueOf(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_MOVIES)), this.activity, this);
        this.observer.startWatching();
        Intent service = new Intent(this.context, ScreenRecordService.class);
        service.putExtra("code", this.resultCode);
        service.putExtra("data", (Parcelable)data);
        service.putExtra("audio", this.isAudioEnabled);
        service.putExtra("width", this.mScreenWidth);
        service.putExtra("height", this.mScreenHeight);
        service.putExtra("density", this.mScreenDensity);
        service.putExtra("quality", this.isVideoHDEnabled);
        service.putExtra("path", this.outputPath);
        service.putExtra("fileName", this.fileName);
        service.putExtra("audioBitrate", this.audioBitrate);
        service.putExtra("audioSamplingRate", this.audioSamplingRate);
        service.putExtra("notificationSmallBitmap", this.byteArray);
        service.putExtra("notificationTitle", this.notificationTitle);
        service.putExtra("notificationDescription", this.notificationDescription);
        service.putExtra("shouldShowNotification", this.shouldShowNotification);
        service.putExtra("notificationButtonText", this.notificationButtonText);
        this.context.startService(service);
    }

    @Override
    public void callback() {
        this.observer.stopWatching();
        this.hbRecorderListener.HBRecorderOnComplete();
    }
}

