/*
 * Decompiled with CFR 0.152.
 */
package es.dmoral.toasty;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.annotation.CheckResult;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import es.dmoral.toasty.R;
import es.dmoral.toasty.ToastyUtils;

@SuppressLint(value={"InflateParams"})
public class Toasty {
    @ColorInt
    private static int DEFAULT_TEXT_COLOR = Color.parseColor((String)"#FFFFFF");
    @ColorInt
    private static int ERROR_COLOR = Color.parseColor((String)"#D50000");
    @ColorInt
    private static int INFO_COLOR = Color.parseColor((String)"#3F51B5");
    @ColorInt
    private static int SUCCESS_COLOR = Color.parseColor((String)"#388E3C");
    @ColorInt
    private static int WARNING_COLOR = Color.parseColor((String)"#FFA900");
    @ColorInt
    private static int NORMAL_COLOR = Color.parseColor((String)"#353A3E");
    private static final Typeface LOADED_TOAST_TYPEFACE;
    private static Typeface currentTypeface;
    private static int textSize;
    private static boolean tintIcon;

    private Toasty() {
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull CharSequence message) {
        return Toasty.normal(context, message, 0, null, false);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull CharSequence message, Drawable icon) {
        return Toasty.normal(context, message, 0, icon, true);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull CharSequence message, int duration) {
        return Toasty.normal(context, message, duration, null, false);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull CharSequence message, int duration, Drawable icon) {
        return Toasty.normal(context, message, duration, icon, true);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull CharSequence message, int duration, Drawable icon, boolean withIcon) {
        return Toasty.custom(context, message, icon, NORMAL_COLOR, duration, withIcon, true);
    }

    @CheckResult
    public static Toast warning(@NonNull Context context, @NonNull CharSequence message) {
        return Toasty.warning(context, message, 0, true);
    }

    @CheckResult
    public static Toast warning(@NonNull Context context, @NonNull CharSequence message, int duration) {
        return Toasty.warning(context, message, duration, true);
    }

    @CheckResult
    public static Toast warning(@NonNull Context context, @NonNull CharSequence message, int duration, boolean withIcon) {
        return Toasty.custom(context, message, ToastyUtils.getDrawable(context, R.drawable.ic_error_outline_white_48dp), WARNING_COLOR, duration, withIcon, true);
    }

    @CheckResult
    public static Toast info(@NonNull Context context, @NonNull CharSequence message) {
        return Toasty.info(context, message, 0, true);
    }

    @CheckResult
    public static Toast info(@NonNull Context context, @NonNull CharSequence message, int duration) {
        return Toasty.info(context, message, duration, true);
    }

    @CheckResult
    public static Toast info(@NonNull Context context, @NonNull CharSequence message, int duration, boolean withIcon) {
        return Toasty.custom(context, message, ToastyUtils.getDrawable(context, R.drawable.ic_info_outline_white_48dp), INFO_COLOR, duration, withIcon, true);
    }

    @CheckResult
    public static Toast success(@NonNull Context context, @NonNull CharSequence message) {
        return Toasty.success(context, message, 0, true);
    }

    @CheckResult
    public static Toast success(@NonNull Context context, @NonNull CharSequence message, int duration) {
        return Toasty.success(context, message, duration, true);
    }

    @CheckResult
    public static Toast success(@NonNull Context context, @NonNull CharSequence message, int duration, boolean withIcon) {
        return Toasty.custom(context, message, ToastyUtils.getDrawable(context, R.drawable.ic_check_white_48dp), SUCCESS_COLOR, duration, withIcon, true);
    }

    @CheckResult
    public static Toast error(@NonNull Context context, @NonNull CharSequence message) {
        return Toasty.error(context, message, 0, true);
    }

    @CheckResult
    public static Toast error(@NonNull Context context, @NonNull CharSequence message, int duration) {
        return Toasty.error(context, message, duration, true);
    }

    @CheckResult
    public static Toast error(@NonNull Context context, @NonNull CharSequence message, int duration, boolean withIcon) {
        return Toasty.custom(context, message, ToastyUtils.getDrawable(context, R.drawable.ic_clear_white_48dp), ERROR_COLOR, duration, withIcon, true);
    }

    @CheckResult
    public static Toast custom(@NonNull Context context, @NonNull CharSequence message, Drawable icon, int duration, boolean withIcon) {
        return Toasty.custom(context, message, icon, -1, duration, withIcon, false);
    }

    @CheckResult
    public static Toast custom(@NonNull Context context, @NonNull CharSequence message, @DrawableRes int iconRes, @ColorInt int tintColor, int duration, boolean withIcon, boolean shouldTint) {
        return Toasty.custom(context, message, ToastyUtils.getDrawable(context, iconRes), tintColor, duration, withIcon, shouldTint);
    }

    @SuppressLint(value={"ShowToast"})
    @CheckResult
    public static Toast custom(@NonNull Context context, @NonNull CharSequence message, Drawable icon, @ColorInt int tintColor, int duration, boolean withIcon, boolean shouldTint) {
        Toast currentToast = Toast.makeText((Context)context, (CharSequence)"", (int)duration);
        View toastLayout = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(R.layout.toast_layout, null);
        ImageView toastIcon = (ImageView)toastLayout.findViewById(R.id.toast_icon);
        TextView toastTextView = (TextView)toastLayout.findViewById(R.id.toast_text);
        Drawable drawableFrame = shouldTint ? ToastyUtils.tint9PatchDrawableFrame(context, tintColor) : ToastyUtils.getDrawable(context, R.drawable.toast_frame);
        ToastyUtils.setBackground(toastLayout, drawableFrame);
        if (withIcon) {
            if (icon == null) {
                throw new IllegalArgumentException("Avoid passing 'icon' as null if 'withIcon' is set to true");
            }
            if (tintIcon) {
                icon = ToastyUtils.tintIcon(icon, DEFAULT_TEXT_COLOR);
            }
            ToastyUtils.setBackground((View)toastIcon, icon);
        } else {
            toastIcon.setVisibility(8);
        }
        toastTextView.setText(message);
        toastTextView.setTextColor(DEFAULT_TEXT_COLOR);
        toastTextView.setTypeface(currentTypeface);
        toastTextView.setTextSize(2, (float)textSize);
        currentToast.setView(toastLayout);
        return currentToast;
    }

    static /* synthetic */ int access$000() {
        return DEFAULT_TEXT_COLOR;
    }

    static /* synthetic */ int access$100() {
        return ERROR_COLOR;
    }

    static /* synthetic */ int access$200() {
        return INFO_COLOR;
    }

    static /* synthetic */ int access$300() {
        return SUCCESS_COLOR;
    }

    static /* synthetic */ int access$400() {
        return WARNING_COLOR;
    }

    static /* synthetic */ Typeface access$500() {
        return currentTypeface;
    }

    static /* synthetic */ int access$600() {
        return textSize;
    }

    static /* synthetic */ boolean access$700() {
        return tintIcon;
    }

    static {
        currentTypeface = LOADED_TOAST_TYPEFACE = Typeface.create((String)"sans-serif-condensed", (int)0);
        textSize = 16;
        tintIcon = true;
    }

    public static class Config {
        @ColorInt
        private int DEFAULT_TEXT_COLOR = Toasty.access$000();
        @ColorInt
        private int ERROR_COLOR = Toasty.access$100();
        @ColorInt
        private int INFO_COLOR = Toasty.access$200();
        @ColorInt
        private int SUCCESS_COLOR = Toasty.access$300();
        @ColorInt
        private int WARNING_COLOR = Toasty.access$400();
        private Typeface typeface = Toasty.access$500();
        private int textSize = Toasty.access$600();
        private boolean tintIcon = Toasty.access$700();

        private Config() {
        }

        @CheckResult
        public static Config getInstance() {
            return new Config();
        }

        public static void reset() {
            DEFAULT_TEXT_COLOR = Color.parseColor((String)"#FFFFFF");
            ERROR_COLOR = Color.parseColor((String)"#D50000");
            INFO_COLOR = Color.parseColor((String)"#3F51B5");
            SUCCESS_COLOR = Color.parseColor((String)"#388E3C");
            WARNING_COLOR = Color.parseColor((String)"#FFA900");
            currentTypeface = LOADED_TOAST_TYPEFACE;
            textSize = 16;
            tintIcon = true;
        }

        @CheckResult
        public Config setTextColor(@ColorInt int textColor) {
            this.DEFAULT_TEXT_COLOR = textColor;
            return this;
        }

        @CheckResult
        public Config setErrorColor(@ColorInt int errorColor) {
            this.ERROR_COLOR = errorColor;
            return this;
        }

        @CheckResult
        public Config setInfoColor(@ColorInt int infoColor) {
            this.INFO_COLOR = infoColor;
            return this;
        }

        @CheckResult
        public Config setSuccessColor(@ColorInt int successColor) {
            this.SUCCESS_COLOR = successColor;
            return this;
        }

        @CheckResult
        public Config setWarningColor(@ColorInt int warningColor) {
            this.WARNING_COLOR = warningColor;
            return this;
        }

        @CheckResult
        public Config setToastTypeface(@NonNull Typeface typeface) {
            this.typeface = typeface;
            return this;
        }

        @CheckResult
        public Config setTextSize(int sizeInSp) {
            this.textSize = sizeInSp;
            return this;
        }

        @CheckResult
        public Config tintIcon(boolean tintIcon) {
            this.tintIcon = tintIcon;
            return this;
        }

        public void apply() {
            DEFAULT_TEXT_COLOR = this.DEFAULT_TEXT_COLOR;
            ERROR_COLOR = this.ERROR_COLOR;
            INFO_COLOR = this.INFO_COLOR;
            SUCCESS_COLOR = this.SUCCESS_COLOR;
            WARNING_COLOR = this.WARNING_COLOR;
            currentTypeface = this.typeface;
            textSize = this.textSize;
            tintIcon = this.tintIcon;
        }
    }
}

