/*
 * Decompiled with CFR 0.152.
 */
package es.dmoral.toasty;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.annotation.CheckResult;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import es.dmoral.toasty.R;
import es.dmoral.toasty.ToastyUtils;

@SuppressLint(value={"InflateParams"})
public class Toasty {
    @ColorInt
    private static final int DEFAULT_TEXT_COLOR = Color.parseColor((String)"#FFFFFF");
    @ColorInt
    private static final int ERROR_COLOR = Color.parseColor((String)"#D50000");
    @ColorInt
    private static final int INFO_COLOR = Color.parseColor((String)"#3F51B5");
    @ColorInt
    private static final int SUCCESS_COLOR = Color.parseColor((String)"#388E3C");
    @ColorInt
    private static final int WARNING_COLOR = Color.parseColor((String)"#FFA900");
    private static final String TOAST_TYPEFACE = "sans-serif-condensed";

    private Toasty() {
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull CharSequence message) {
        return Toasty.normal(context, message, 0, null, false);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull CharSequence message, Drawable icon) {
        return Toasty.normal(context, message, 0, icon, true);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull CharSequence message, int duration) {
        return Toasty.normal(context, message, duration, null, false);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull CharSequence message, int duration, Drawable icon) {
        return Toasty.normal(context, message, duration, icon, true);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull CharSequence message, int duration, Drawable icon, boolean withIcon) {
        return Toasty.custom(context, message, icon, DEFAULT_TEXT_COLOR, duration, withIcon);
    }

    @CheckResult
    public static Toast warning(@NonNull Context context, @NonNull CharSequence message) {
        return Toasty.warning(context, message, 0, true);
    }

    @CheckResult
    public static Toast warning(@NonNull Context context, @NonNull CharSequence message, int duration) {
        return Toasty.warning(context, message, duration, true);
    }

    @CheckResult
    public static Toast warning(@NonNull Context context, @NonNull CharSequence message, int duration, boolean withIcon) {
        return Toasty.custom(context, message, ToastyUtils.getDrawable(context, R.drawable.ic_error_outline_white_48dp), DEFAULT_TEXT_COLOR, WARNING_COLOR, duration, withIcon, true);
    }

    @CheckResult
    public static Toast info(@NonNull Context context, @NonNull CharSequence message) {
        return Toasty.info(context, message, 0, true);
    }

    @CheckResult
    public static Toast info(@NonNull Context context, @NonNull CharSequence message, int duration) {
        return Toasty.info(context, message, duration, true);
    }

    @CheckResult
    public static Toast info(@NonNull Context context, @NonNull CharSequence message, int duration, boolean withIcon) {
        return Toasty.custom(context, message, ToastyUtils.getDrawable(context, R.drawable.ic_info_outline_white_48dp), DEFAULT_TEXT_COLOR, INFO_COLOR, duration, withIcon, true);
    }

    @CheckResult
    public static Toast success(@NonNull Context context, @NonNull CharSequence message) {
        return Toasty.success(context, message, 0, true);
    }

    @CheckResult
    public static Toast success(@NonNull Context context, @NonNull CharSequence message, int duration) {
        return Toasty.success(context, message, duration, true);
    }

    @CheckResult
    public static Toast success(@NonNull Context context, @NonNull CharSequence message, int duration, boolean withIcon) {
        return Toasty.custom(context, message, ToastyUtils.getDrawable(context, R.drawable.ic_check_white_48dp), DEFAULT_TEXT_COLOR, SUCCESS_COLOR, duration, withIcon, true);
    }

    @CheckResult
    public static Toast error(@NonNull Context context, @NonNull CharSequence message) {
        return Toasty.error(context, message, 0, true);
    }

    @CheckResult
    public static Toast error(@NonNull Context context, @NonNull CharSequence message, int duration) {
        return Toasty.error(context, message, duration, true);
    }

    @CheckResult
    public static Toast error(@NonNull Context context, @NonNull CharSequence message, int duration, boolean withIcon) {
        return Toasty.custom(context, message, ToastyUtils.getDrawable(context, R.drawable.ic_clear_white_48dp), DEFAULT_TEXT_COLOR, ERROR_COLOR, duration, withIcon, true);
    }

    @CheckResult
    public static Toast custom(@NonNull Context context, @NonNull CharSequence message, Drawable icon, @ColorInt int textColor, int duration, boolean withIcon) {
        return Toasty.custom(context, message, icon, textColor, -1, duration, withIcon, false);
    }

    @CheckResult
    public static Toast custom(@NonNull Context context, @NonNull CharSequence message, @DrawableRes int iconRes, @ColorInt int textColor, @ColorInt int tintColor, int duration, boolean withIcon, boolean shouldTint) {
        return Toasty.custom(context, message, ToastyUtils.getDrawable(context, iconRes), textColor, tintColor, duration, withIcon, shouldTint);
    }

    @CheckResult
    public static Toast custom(@NonNull Context context, @NonNull CharSequence message, Drawable icon, @ColorInt int textColor, @ColorInt int tintColor, int duration, boolean withIcon, boolean shouldTint) {
        Toast currentToast = new Toast(context);
        View toastLayout = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(R.layout.toast_layout, null);
        ImageView toastIcon = (ImageView)toastLayout.findViewById(R.id.toast_icon);
        TextView toastTextView = (TextView)toastLayout.findViewById(R.id.toast_text);
        Drawable drawableFrame = shouldTint ? ToastyUtils.tint9PatchDrawableFrame(context, tintColor) : ToastyUtils.getDrawable(context, R.drawable.toast_frame);
        ToastyUtils.setBackground(toastLayout, drawableFrame);
        if (withIcon) {
            if (icon == null) {
                throw new IllegalArgumentException("Avoid passing 'icon' as null if 'withIcon' is set to true");
            }
            ToastyUtils.setBackground((View)toastIcon, icon);
        } else {
            toastIcon.setVisibility(8);
        }
        toastTextView.setTextColor(textColor);
        toastTextView.setText(message);
        toastTextView.setTypeface(Typeface.create((String)TOAST_TYPEFACE, (int)0));
        currentToast.setView(toastLayout);
        currentToast.setDuration(duration);
        return currentToast;
    }
}

