/*
 * Decompiled with CFR 0.152.
 */
package com.sematext.logseneandroid;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.sematext.logseneandroid.SqliteObjectQueue;
import com.sematext.logseneandroid.logsene.ApiResponse;
import com.sematext.logseneandroid.logsene.Bulk;
import com.sematext.logseneandroid.logsene.LogseneClient;
import java.io.IOException;
import java.util.List;
import org.json.JSONObject;

public class LogWorker
extends Worker {
    private static final String LOG_TAG = "Logsene";
    private static final int MAX_BULK_SIZE = 50;
    private static final int MAX_ATTEMPTS = 3;
    private LogseneClient client;
    private String appToken;
    private String type;
    private final Context context;
    private SqliteObjectQueue preflightQueue;

    public LogWorker(@NonNull Context context, @NonNull WorkerParameters params) {
        super(context, params);
        this.context = context;
    }

    public ListenableWorker.Result doWork() {
        this.appToken = this.getInputData().getString("LOGSENE_APPTOKEN");
        this.type = this.getInputData().getString("LOGSENE_TYPE");
        this.client = new LogseneClient(this.getInputData().getString("LOGSENE_RECEIVERURL"), this.appToken);
        this.preflightQueue = new SqliteObjectQueue(this.context, "logs");
        long size = this.preflightQueue.size();
        Log.d((String)LOG_TAG, (String)("Worker started, message queue size = " + size));
        if (size <= 0L) {
            return ListenableWorker.Result.success();
        }
        boolean success = this.sendInBatches();
        if (!success) {
            Log.e((String)LOG_TAG, (String)"Worker failed to send logs");
            return ListenableWorker.Result.failure();
        }
        Log.d((String)LOG_TAG, (String)("Worker succeeded in sending logs, message queue size = " + this.preflightQueue.size()));
        return ListenableWorker.Result.success();
    }

    private boolean sendInBatches() {
        boolean success = false;
        List<JSONObject> batch = this.preflightQueue.peek(50);
        do {
            if (!this.sendBatch(batch)) {
                return success;
            }
            success = true;
            this.preflightQueue.remove(batch.size());
            batch = this.preflightQueue.peek(50);
        } while (batch.size() > 0);
        return success;
    }

    private boolean sendBatch(List<JSONObject> batch) {
        Bulk.Builder bulkBuilder = new Bulk.Builder();
        for (JSONObject obj : batch) {
            bulkBuilder.addSource(obj.toString(), this.type);
        }
        return this.attemptExecute(bulkBuilder.build(), 3);
    }

    private boolean attemptExecute(Bulk bulk, int leftAttempts) {
        if (leftAttempts == 0) {
            return false;
        }
        --leftAttempts;
        try {
            Log.d((String)LOG_TAG, (String)"Attempting to send bulk request");
            ApiResponse result = this.client.execute(bulk);
            if (!result.isSuccessful()) {
                Log.e((String)LOG_TAG, (String)String.format("Bad status code (%d) returned from api. Response: %s", result.getHttpResponse().code(), result.getBody()));
                return false;
            }
            JSONObject json = result.getJson();
            if (json != null && Boolean.parseBoolean(json.optString("errors", "false"))) {
                Log.e((String)LOG_TAG, (String)String.format("Unable to index all documents. Response: %s\nRequest: %s", result.getBody(), bulk.toString(this.appToken)));
            }
            return true;
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)"Error while sending logs", (Throwable)e);
            return this.attemptExecute(bulk, leftAttempts);
        }
    }
}

