/*
 * Decompiled with CFR 0.152.
 */
package com.sematext.logseneandroid.logsene;

import com.sematext.logseneandroid.Utils;
import com.sematext.logseneandroid.logsene.LogseneClient;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class Bulk {
    private final List<String> sources;
    private final List<String> types;

    public Bulk(List<String> sources, List<String> types) {
        Utils.requireNonNull(sources);
        Utils.requireNonNull(types);
        if (sources.size() != types.size()) {
            throw new IllegalArgumentException("sources and types should have the same size");
        }
        this.sources = sources;
        this.types = types;
    }

    public RequestBody toBody(String index) {
        return RequestBody.create((MediaType)LogseneClient.JSON, (String)this.toString(index));
    }

    public String toString(String index) {
        Utils.requireNonNull(index);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.sources.size(); ++i) {
            sb.append(String.format("{ \"index\" : { \"_index\": \"%s\", \"_type\" : \"%s\" } }\n", index, this.types.get(i)));
            sb.append(this.sources.get(i).trim() + "\n");
        }
        return sb.toString();
    }

    public static class Builder {
        public List<String> sources = new ArrayList<String>();
        public List<String> types = new ArrayList<String>();

        public Builder addSource(String source, String type) {
            Utils.requireNonNull(source);
            Utils.requireNonNull(type);
            this.sources.add(source);
            this.types.add(type);
            return this;
        }

        public Bulk build() {
            return new Bulk(this.sources, this.types);
        }
    }
}

