/*
 * Decompiled with CFR 0.152.
 */
package com.sematext.logseneandroid.logsene;

import android.util.Log;
import java.io.IOException;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class ApiResponse {
    private static final String TAG = "ApiResponse";
    private Response httpResponse;
    private JSONObject json;
    private String body;

    private ApiResponse(Response httpResponse) {
        this.httpResponse = httpResponse;
        try {
            this.body = httpResponse.body().string();
            this.json = new JSONObject(this.body);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Unable to deserialize json response", (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"IO exception while reading body", (Throwable)e);
        }
    }

    public static ApiResponse fromHttpResponse(Response httpResponse) {
        return new ApiResponse(httpResponse);
    }

    public boolean isSuccessful() {
        return this.httpResponse.isSuccessful();
    }

    public Response getHttpResponse() {
        return this.httpResponse;
    }

    public JSONObject getJson() {
        return this.json;
    }

    public String getBody() {
        return this.body;
    }
}

