/*
 * Decompiled with CFR 0.152.
 */
package com.sematext.logseneandroid;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.Log;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.ExistingWorkPolicy;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;
import com.sematext.logseneandroid.Installation;
import com.sematext.logseneandroid.LogWorker;
import com.sematext.logseneandroid.LogseneLocationListener;
import com.sematext.logseneandroid.SqliteObjectQueue;
import com.sematext.logseneandroid.Utils;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class Logsene {
    public static final String KEY_RECEIVERURL = "LOGSENE_RECEIVERURL";
    public static final String KEY_APPTOKEN = "LOGSENE_APPTOKEN";
    public static final String KEY_TYPE = "LOGSENE_TYPE";
    private final String TAG = this.getClass().getSimpleName();
    private final String FLUSH_WORKER_TAG = "com.sematext.android.LogWorker.unconstrained";
    private final String INTERVAL_WORKER_TAG = "com.sematext.android.LogWorker.interval";
    private final String ONQUEUE_WORKER_TAG = "com.sematext.android.LogWorker.onqueue";
    private final String RECEIVER_URL = "https://logsene-receiver.sematext.com";
    private final int DEFAULT_MAX_OFFLINE_MESSAGES = 5000;
    private final int DEFAULT_MIN_BATCH_SIZE = 10;
    private final int DEFAULT_MIN_TIME_DELAY = 60000;
    private static final int DEFAULT_TIME_INTERVAL = 900000;
    private static JSONObject defaultMeta;
    private final Context context;
    private String versionName;
    private Integer versionCode;
    private String uuid;
    private SqliteObjectQueue preflightQueue;
    private long lastScheduled = -1L;
    private String appToken;
    private String type;
    private String receiverUrl;
    private int maxOfflineMessages;
    private long timeInterval;
    private long minTimeDelay;
    private boolean sendRequiresUnmeteredNetwork;
    private boolean sendRequiresDeviceIdle;
    private boolean sendRequiresBatteryNotLow;
    private boolean isActive;
    private LogseneLocationListener locationListener;

    public Logsene(Context context) {
        this(context, false);
    }

    public Logsene(Context context, boolean automaticLocationEnabled) {
        Utils.requireNonNull(context);
        this.context = context;
        this.uuid = Installation.id(context);
        this.config();
        this.preflightQueue = new SqliteObjectQueue(this.context, this.maxOfflineMessages);
        this.lastScheduled = SystemClock.elapsedRealtime();
        if (automaticLocationEnabled) {
            this.locationListener = new LogseneLocationListener(context);
        }
        this.isActive = true;
        this.schedulePeriodicWorker();
    }

    public long getQueueSize() {
        return this.preflightQueue.size();
    }

    public LogseneLocationListener getLocationListener() {
        return this.locationListener;
    }

    private void config() {
        Bundle data = null;
        try {
            data = this.context.getPackageManager().getApplicationInfo((String)this.context.getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (!data.containsKey("LogseneAppToken")) {
            throw new RuntimeException("Please provide <meta-data name=\"LogseneAppToken\" value=\"yourapptoken\">");
        }
        if (!data.containsKey("LogseneType")) {
            throw new RuntimeException("Please provide <meta-data name=\"LogseneType\" value=\"example\">");
        }
        this.appToken = data.getString("LogseneAppToken");
        this.type = data.getString("LogseneType");
        this.receiverUrl = data.getString("LogseneReceiverUrl", "https://logsene-receiver.sematext.com");
        this.maxOfflineMessages = data.getInt("LogseneMaxOfflineMessages", 5000);
        this.minTimeDelay = data.getInt("LogseneMinTimeDelay", 60000);
        this.timeInterval = data.getInt("LogseneInterval", 900000);
        this.sendRequiresUnmeteredNetwork = data.getBoolean("LogseneSendRequiresUnmeteredNetwork", false);
        this.sendRequiresDeviceIdle = data.getBoolean("LogseneSendRequiresDeviceIdle", false);
        this.sendRequiresBatteryNotLow = data.getBoolean("LogseneSendRequiresBatteryNotLow", false);
        Log.d((String)this.TAG, (String)String.format("Logsene is configured:\n  Type:                                   %s\n  Receiver URL:                           %s\n  Max Offline Messages:                   %d\n  Min Time Trigger:                       %d\n  Max Time Trigger:                       %d\n  Send logs only on unmetered network:    %s\n  Send logs only when device is idle:     %s\n  Send logs only when battery is not low: %s", this.type, this.receiverUrl, this.maxOfflineMessages, this.minTimeDelay, this.timeInterval, this.sendRequiresUnmeteredNetwork, this.sendRequiresDeviceIdle, this.sendRequiresBatteryNotLow));
    }

    public void pause() {
        this.isActive = false;
    }

    public void resume() {
        this.isActive = true;
    }

    public void log(String level, String message) {
        this.log(level, message, null, null);
    }

    public void log(String level, String message, Double lat, Double lon) {
        Utils.requireNonNull(message);
        JSONObject obj = new JSONObject();
        try {
            obj.put("level", (Object)level);
            obj.put("message", (Object)message);
            this.enrichWithLocation(obj);
            this.addLocationToObject(obj, lat, lon);
            this.addToQueue(obj);
        }
        catch (JSONException e) {
            Log.e((String)this.TAG, (String)"Failed to construct json object", (Throwable)e);
        }
    }

    public void debug(String message) {
        this.log("debug", message);
    }

    public void debug(String message, Double lat, Double lon) {
        this.log("debug", message, lat, lon);
    }

    public void info(String message) {
        this.log("info", message);
    }

    public void info(String message, Double lat, Double lon) {
        this.log("info", message, lat, lon);
    }

    public void warn(String message) {
        this.log("warn", message);
    }

    public void warn(String message, Double lat, Double lon) {
        this.log("warn", message, lat, lon);
    }

    public void warn(Throwable error) {
        this.log("warn", error);
    }

    public void warn(Throwable error, Double lat, Double lon) {
        this.log("warn", error, lat, lon);
    }

    public void error(String message) {
        this.log("error", message);
    }

    public void error(String message, Double lat, Double lon) {
        this.log("error", message, lat, lon);
    }

    public void error(Throwable error) {
        this.log("error", error);
    }

    public void error(Throwable error, Double lat, Double lon) {
        this.log("error", error, lat, lon);
    }

    public void log(String level, Throwable error) {
        this.log(level, error, null, null);
    }

    public void log(String level, Throwable error, Double lat, Double lon) {
        Utils.requireNonNull(error);
        JSONObject obj = new JSONObject();
        try {
            obj.put("level", (Object)level);
            obj.put("exception", (Object)error.getClass().toString());
            obj.put("message", (Object)error.getMessage());
            obj.put("stacktrace", (Object)Utils.getStackTrace(error));
            this.enrichWithLocation(obj);
            this.addLocationToObject(obj, lat, lon);
            this.addToQueue(obj);
        }
        catch (JSONException e) {
            Log.e((String)this.TAG, (String)"Failed to construct json object", (Throwable)e);
        }
    }

    public void event(JSONObject object) {
        Utils.requireNonNull(object);
        this.addToQueue(object);
    }

    public static void setDefaultMeta(JSONObject metadata) {
        defaultMeta = metadata;
    }

    public void flushMessageQueue() {
        Log.d((String)this.TAG, (String)("Flushing message queue, message queue size = " + this.preflightQueue.size()));
        this.scheduleUnconstrainedWorker();
    }

    private Data getWorkerData() {
        return new Data.Builder().putString(KEY_RECEIVERURL, this.receiverUrl).putString(KEY_APPTOKEN, this.appToken).putString(KEY_TYPE, this.type).build();
    }

    private Constraints getWorkerConstraints() {
        return new Constraints.Builder().setRequiredNetworkType(this.sendRequiresUnmeteredNetwork ? NetworkType.UNMETERED : NetworkType.CONNECTED).setRequiresDeviceIdle(this.sendRequiresDeviceIdle).setRequiresBatteryNotLow(this.sendRequiresBatteryNotLow).build();
    }

    private void scheduleUnconstrainedWorker() {
        OneTimeWorkRequest workRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(LogWorker.class).addTag("com.sematext.android.LogWorker.unconstrained")).setInputData(this.getWorkerData())).build();
        WorkManager.getInstance().enqueueUniqueWork("com.sematext.android.LogWorker.unconstrained", ExistingWorkPolicy.KEEP, workRequest);
    }

    private void scheduleConstrainedWorker() {
        OneTimeWorkRequest workRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(LogWorker.class).addTag("com.sematext.android.LogWorker.unconstrained")).setInputData(this.getWorkerData())).setConstraints(this.getWorkerConstraints())).build();
        WorkManager.getInstance().enqueueUniqueWork("com.sematext.android.LogWorker.onqueue", ExistingWorkPolicy.KEEP, workRequest);
    }

    private void schedulePeriodicWorker() {
        Constraints workerConstraints = this.getWorkerConstraints();
        PeriodicWorkRequest workRequest = (PeriodicWorkRequest)((PeriodicWorkRequest.Builder)((PeriodicWorkRequest.Builder)((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(LogWorker.class, this.timeInterval, TimeUnit.MILLISECONDS).addTag("com.sematext.android.LogWorker.interval")).setInputData(this.getWorkerData())).setConstraints(workerConstraints)).build();
        WorkManager.getInstance().enqueueUniquePeriodicWork("com.sematext.android.LogWorker.interval", ExistingPeriodicWorkPolicy.KEEP, workRequest);
    }

    private void addToQueue(JSONObject obj) {
        boolean canSend;
        if (this.preflightQueue == null) {
            Log.e((String)this.TAG, (String)"Message queue has not been initialized, message dropped.");
            return;
        }
        assert (obj != null);
        this.enrich(obj);
        this.preflightQueue.add(obj);
        if (this.preflightQueue.size() == (long)this.maxOfflineMessages) {
            Log.d((String)this.TAG, (String)("Message queue overflowing (" + this.preflightQueue.size() + " > " + this.maxOfflineMessages + "), some logs might be lost."));
        }
        boolean bl = canSend = this.lastScheduled == -1L || SystemClock.elapsedRealtime() - this.lastScheduled > this.minTimeDelay;
        if (this.preflightQueue.size() >= 10L && canSend && this.isActive) {
            this.scheduleConstrainedWorker();
            this.lastScheduled = SystemClock.elapsedRealtime();
        }
    }

    private String getVersionName() {
        if (this.versionName == null) {
            PackageInfo pInfo = null;
            try {
                pInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
                this.versionName = pInfo.versionName;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)this.TAG, (String)e.getMessage(), (Throwable)e);
                this.versionName = "n/a";
            }
        }
        return this.versionName;
    }

    private int getVersionCode() {
        if (this.versionCode == null) {
            PackageInfo pInfo = null;
            try {
                pInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
                this.versionCode = pInfo.versionCode;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)this.TAG, (String)e.getMessage(), (Throwable)e);
                this.versionCode = -1;
            }
        }
        return this.versionCode;
    }

    private void enrichWithLocation(JSONObject obj) throws JSONException {
        if (this.locationListener != null) {
            obj.put("location", (Object)this.locationListener.getLocationAsString());
        }
    }

    private void addLocationToObject(JSONObject obj, Double lat, Double lon) throws JSONException {
        if (lat != null && lon != null) {
            obj.put("lat", (Object)lat);
            obj.put("lon", (Object)lon);
        }
    }

    private void enrich(JSONObject obj) {
        assert (obj != null);
        try {
            if (!obj.has("@timestamp")) {
                obj.put("@timestamp", (Object)Utils.iso8601());
            }
            if (!obj.has("meta")) {
                JSONObject metadata = new JSONObject();
                metadata.put("versionCode", this.getVersionCode());
                metadata.put("osRelease", (Object)Build.VERSION.RELEASE);
                metadata.put("osType", (Object)"Android");
                metadata.put("uuid", (Object)this.uuid);
                if (defaultMeta != null) {
                    Iterator keys = defaultMeta.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        metadata.put(key, defaultMeta.get(key));
                    }
                }
                obj.put("meta", (Object)metadata);
            }
            obj.put("version", (Object)this.getVersionName());
            if (obj.has("lat") && obj.has("lon")) {
                JSONObject geo = new JSONObject();
                geo.put("location", (Object)String.format("%.2f,%.2f", obj.getDouble("lat"), obj.getDouble("lon")));
                obj.remove("lat");
                obj.remove("lon");
                obj.put("geo", (Object)geo);
            }
        }
        catch (JSONException e) {
            Log.e((String)this.TAG, (String)"Failed to construct json object", (Throwable)e);
        }
    }
}

