/*
 * Decompiled with CFR 0.152.
 */
package com.sematext.logseneandroid;

import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import com.sematext.logseneandroid.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

class SqliteObjectQueue {
    private static final String TABLE_NAME = "objects";
    private static final int DEFAULT_MAX_SIZE = 5000;
    private final SQLiteDatabase db;
    private final int maxSize;
    private static final ConcurrentHashMap<String, Long> sizeCache = new ConcurrentHashMap();

    public SqliteObjectQueue(Context context) {
        Utils.requireNonNull(context);
        ObjectDbHelper dbHelper = ObjectDbHelper.getInstance(context);
        this.db = dbHelper.getWritableDatabase();
        this.maxSize = 5000;
    }

    public SqliteObjectQueue(Context context, int maxSize) {
        Utils.requireNonNull(context);
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize must be greater than 0");
        }
        ObjectDbHelper dbHelper = ObjectDbHelper.getInstance(context);
        this.db = dbHelper.getWritableDatabase();
        this.maxSize = maxSize;
    }

    public long size() {
        if (sizeCache.get("logs") == null) {
            sizeCache.put("logs", DatabaseUtils.queryNumEntries((SQLiteDatabase)this.db, (String)TABLE_NAME));
        }
        return sizeCache.get("logs");
    }

    public void add(JSONObject obj) {
        Utils.requireNonNull(obj);
        this.db.execSQL("INSERT INTO objects(data) VALUES (?)", new Object[]{obj.toString()});
        if (sizeCache.get("logs") != null) {
            sizeCache.put("logs", sizeCache.get("logs") + 1L);
        }
        if (this.size() > (long)this.maxSize) {
            this.remove(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<JSONObject> peek(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException("max must be greater than 0");
        }
        ArrayList<JSONObject> results = new ArrayList<JSONObject>();
        Cursor c = this.db.query(TABLE_NAME, new String[]{"data"}, null, null, null, null, "id asc", String.valueOf(max));
        try {
            while (c.moveToNext()) {
                String data = c.getString(c.getColumnIndex("data"));
                try {
                    JSONObject o = new JSONObject(data);
                    results.add(o);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                    return results;
                }
            }
        }
        finally {
            if (c != null && !c.isClosed()) {
                c.close();
            }
        }
    }

    public void remove(int n) {
        this.db.execSQL(String.format("DELETE FROM %s WHERE `id` IN (SELECT `id` FROM %s ORDER BY `id` ASC limit %d);", TABLE_NAME, TABLE_NAME, n));
        SQLiteStatement stmt = this.db.compileStatement("SELECT CHANGES()");
        long result = stmt.simpleQueryForLong();
        if (sizeCache.get("logs") != null) {
            sizeCache.put("logs", sizeCache.get("logs") - result);
        }
        stmt.close();
    }

    public static class ObjectDbHelper
    extends SQLiteOpenHelper {
        public static final int DATABASE_VERSION = 2;
        public static final String DATABASE_NAME = "logs";
        private static ObjectDbHelper dbInstance;

        public static synchronized ObjectDbHelper getInstance(Context context) {
            if (dbInstance == null) {
                dbInstance = new ObjectDbHelper(context);
            }
            return dbInstance;
        }

        private ObjectDbHelper(Context context) {
            super(context, DATABASE_NAME, null, 2);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE objects (id INTEGER PRIMARY KEY, data TEXT);");
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            db.execSQL("DROP TABLE IF EXISTS objects;");
            this.onCreate(db);
        }

        public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            this.onUpgrade(db, oldVersion, newVersion);
        }
    }
}

