/*
 * Decompiled with CFR 0.152.
 */
package com.sematext.logseneandroid;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import java.util.List;

public class LogseneLocationListener
extends Activity
implements LocationListener {
    private static final int REQUEST_LOCATION = 382173921;
    private LocationManager locationManager;
    private Location location;
    private boolean enabled;

    public LogseneLocationListener(Context context) {
        this.locationManager = (LocationManager)context.getSystemService("location");
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"}, (int)382173921);
        } else {
            this.enabled = true;
            this.setupLocationRequests();
            this.retrieveLocation();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 382173921 && grantResults[0] == -1) {
            this.enabled = true;
            this.setupLocationRequests();
            this.retrieveLocation();
        }
    }

    protected void setupLocationRequests() throws SecurityException {
        List enabledLocationProviders = this.locationManager.getProviders(true);
        for (String provider : enabledLocationProviders) {
            this.locationManager.requestLocationUpdates(provider, 1000L, 0.0f, (LocationListener)this);
        }
    }

    public void retrieveLocation() throws SecurityException {
        List enabledLocationProviders = this.locationManager.getProviders(true);
        Location bestKnownLocation = null;
        for (String provider : enabledLocationProviders) {
            Location locationFromProvider = this.locationManager.getLastKnownLocation(provider);
            if (locationFromProvider == null || bestKnownLocation != null && !(locationFromProvider.getAccuracy() < bestKnownLocation.getAccuracy())) continue;
            bestKnownLocation = locationFromProvider;
        }
        this.location = bestKnownLocation;
    }

    public boolean isLocationPresent() {
        return this.enabled && this.location != null;
    }

    public String getLocationAsString() {
        try {
            if (this.isLocationPresent()) {
                return String.format("%.2f,%.2f", this.location.getLatitude(), this.location.getLongitude());
            }
        }
        catch (SecurityException se) {
            Log.e((String)"ERROR", (String)"Location services not allowed", (Throwable)se);
        }
        return "";
    }

    public void onLocationChanged(Location location) {
    }

    public void onProviderDisabled(String provider) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }
}

