/*
 * Decompiled with CFR 0.152.
 */
package com.sematext.android;

import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import com.sematext.android.Utils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

class SqliteObjectQueue {
    private static final String TABLE_NAME = "objects";
    private static final int DEFAULT_MAX_SIZE = 5000;
    private final SQLiteDatabase db;
    private final int maxSize;
    private Long cachedCount;

    public SqliteObjectQueue(Context context, String dbName) {
        Utils.requireNonNull(context);
        Utils.requireNonNull(dbName);
        ObjectDbHelper dbHelper = new ObjectDbHelper(context, dbName);
        this.db = dbHelper.getWritableDatabase();
        this.maxSize = 5000;
    }

    public SqliteObjectQueue(Context context, String dbName, int maxSize) {
        Utils.requireNonNull(context);
        Utils.requireNonNull(dbName);
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize must be greater than 0");
        }
        ObjectDbHelper dbHelper = new ObjectDbHelper(context, dbName);
        this.db = dbHelper.getWritableDatabase();
        this.maxSize = maxSize;
    }

    public long size() {
        if (this.cachedCount == null) {
            this.cachedCount = DatabaseUtils.queryNumEntries((SQLiteDatabase)this.db, (String)TABLE_NAME);
        }
        return this.cachedCount;
    }

    public void add(JSONObject obj) {
        Utils.requireNonNull(obj);
        this.db.execSQL("INSERT INTO objects(data) VALUES (?)", new Object[]{obj.toString()});
        if (this.cachedCount != null) {
            this.cachedCount = this.cachedCount + 1L;
        }
        if (this.size() > (long)this.maxSize) {
            this.remove(1);
        }
    }

    public List<JSONObject> peek(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException("max must be greater than 0");
        }
        ArrayList<JSONObject> results = new ArrayList<JSONObject>();
        Cursor c = this.db.query(TABLE_NAME, new String[]{"data"}, null, null, null, null, "id asc", String.valueOf(max));
        while (c.moveToNext()) {
            String data = c.getString(c.getColumnIndex("data"));
            try {
                JSONObject o = new JSONObject(data);
                results.add(o);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return results;
    }

    public void remove(int n) {
        this.db.execSQL(String.format("DELETE FROM %s WHERE `id` IN (SELECT `id` FROM %s ORDER BY `id` ASC limit %d);", TABLE_NAME, TABLE_NAME, n));
        SQLiteStatement stmt = this.db.compileStatement("SELECT CHANGES()");
        long result = stmt.simpleQueryForLong();
        if (this.cachedCount != null) {
            this.cachedCount = this.cachedCount - result;
        }
    }

    public class ObjectDbHelper
    extends SQLiteOpenHelper {
        public static final int DATABASE_VERSION = 2;

        public ObjectDbHelper(Context context, String dbName) {
            super(context, dbName, null, 2);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE objects (id INTEGER PRIMARY KEY, data TEXT);");
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            db.execSQL("DROP TABLE IF EXISTS objects;");
            this.onCreate(db);
        }

        public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            this.onUpgrade(db, oldVersion, newVersion);
        }
    }
}

