/*
 * Decompiled with CFR 0.152.
 */
package com.sematext.android;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.sematext.android.SqliteObjectQueue;
import com.sematext.android.logsene.ApiResponse;
import com.sematext.android.logsene.Bulk;
import com.sematext.android.logsene.LogseneClient;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

class LogWorker {
    private static final String LOG_TAG = "Logsene";
    private final BlockingQueue<JSONObject> queue = new LinkedBlockingQueue<JSONObject>();
    private final LogseneClient client;
    private final String appToken;
    private final String type;
    private final int preflightSize;
    private final Appender appender;
    private final Context context;

    public LogWorker(Context context, LogseneClient client, String appToken, String type, int preflightSize) throws IOException {
        this.client = client;
        this.appToken = appToken;
        this.type = type;
        this.context = context;
        this.preflightSize = preflightSize;
        this.appender = new Appender();
        Thread appenderThread = new Thread(this.appender);
        appenderThread.start();
    }

    public void addToQueue(JSONObject obj) {
        this.queue.add(obj);
    }

    private class Appender
    implements Runnable {
        private static final int MIN_BATCH_SIZE = 10;
        private static final int MAX_BULK_SIZE = 50;
        private static final int MAX_TIME_TRIGGER = 60000;
        private static final int MAX_ATTEMPTS = 3;
        private final SqliteObjectQueue preflightQueue;

        public Appender() throws IOException {
            this.preflightQueue = new SqliteObjectQueue(LogWorker.this.context, "logs", LogWorker.this.preflightSize);
        }

        @Override
        public void run() {
            long lastSend = System.currentTimeMillis();
            while (true) {
                try {
                    JSONObject newMessage = (JSONObject)LogWorker.this.queue.poll(1L, TimeUnit.SECONDS);
                    if (newMessage != null) {
                        this.preflightQueue.add(newMessage);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                long sinceLastSend = System.currentTimeMillis() - lastSend;
                if (!this.isNetworkAvailable() || this.preflightQueue.size() <= 0L || this.preflightQueue.size() < 10L && sinceLastSend <= 60000L) continue;
                this.sendInBatches();
                lastSend = System.currentTimeMillis();
            }
        }

        private void sendInBatches() {
            List<JSONObject> batch = this.preflightQueue.peek(50);
            do {
                if (!this.sendBatch(batch)) {
                    return;
                }
                this.preflightQueue.remove(batch.size());
                batch = this.preflightQueue.peek(50);
            } while (batch.size() > 0);
        }

        private boolean sendBatch(List<JSONObject> batch) {
            Bulk.Builder bulkBuilder = new Bulk.Builder();
            for (JSONObject obj : batch) {
                bulkBuilder.addSource(obj.toString(), LogWorker.this.type);
            }
            return this.attemptExecute(bulkBuilder.build(), 3);
        }

        private boolean attemptExecute(Bulk bulk, int leftAttempts) {
            if (leftAttempts == 0) {
                return false;
            }
            --leftAttempts;
            try {
                Log.d((String)LogWorker.LOG_TAG, (String)"Attempting to send bulk request");
                ApiResponse result = LogWorker.this.client.execute(bulk);
                if (!result.isSuccessful()) {
                    Log.e((String)LogWorker.LOG_TAG, (String)String.format("Bad status code (%d) returned from api. Response: %s", result.getHttpResponse().code(), result.getBody()));
                    return false;
                }
                JSONObject json = result.getJson();
                if (json != null && Boolean.parseBoolean(json.optString("errors", "false"))) {
                    Log.e((String)LogWorker.LOG_TAG, (String)String.format("Unable to index all documents. Response: %s\nRequest: %s", result.getBody(), bulk.toString(LogWorker.this.appToken)));
                }
                return true;
            }
            catch (IOException e) {
                Log.e((String)LogWorker.LOG_TAG, (String)"Error while sending logs", (Throwable)e);
                return this.attemptExecute(bulk, leftAttempts);
            }
        }

        private boolean isNetworkAvailable() {
            ConnectivityManager connectivityManager = (ConnectivityManager)LogWorker.this.context.getSystemService("connectivity");
            NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
            return activeNetworkInfo != null && activeNetworkInfo.isConnected();
        }
    }
}

