/*
 * Decompiled with CFR 0.152.
 */
package com.sematext.android.logsene;

import com.sematext.android.Utils;
import com.sematext.android.logsene.ApiResponse;
import com.sematext.android.logsene.Bulk;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class LogseneClient {
    private final OkHttpClient client = new OkHttpClient();
    private final String receiverUrl;
    private final String appToken;
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public LogseneClient(String receiverUrl, String appToken) {
        Utils.requireNonNull(receiverUrl);
        Utils.requireNonNull(appToken);
        receiverUrl = receiverUrl.trim();
        if (receiverUrl.endsWith("/")) {
            receiverUrl = receiverUrl.substring(0, receiverUrl.length() - 1);
        }
        this.receiverUrl = receiverUrl;
        this.appToken = appToken;
    }

    public ApiResponse execute(Bulk bulk) throws IOException {
        Utils.requireNonNull(bulk);
        Request request = new Request.Builder().url(this.receiverUrl + "/_bulk").post(bulk.toBody(this.appToken)).build();
        Response response = this.client.newCall(request).execute();
        return ApiResponse.fromHttpResponse(response);
    }
}

