/*
 * Decompiled with CFR 0.152.
 */
package com.sematext.android;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.sematext.android.LogWorker;
import com.sematext.android.logsene.LogseneClient;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class LogseneService
extends Service {
    private final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private final String RECEIVER_URL = "https://logsene-receiver.sematext.com";
    private final int OFFLINE_MAX_MESSAGES = 5000;
    private LogseneClient client;
    private LogWorker worker;

    private void config(Bundle data) {
        if (!data.containsKey("appToken")) {
            throw new RuntimeException("Please provide <meta-data name=\"appToken\" value=\"yourapptoken\"> in <service>");
        }
        if (!data.containsKey("type")) {
            throw new RuntimeException("Please provide <meta-data name=\"type\" value=\"example\"> in <service>");
        }
        String appToken = data.getString("appToken");
        String type = data.getString("type");
        String receiverUrl = data.getString("receiverUrl", "https://logsene-receiver.sematext.com");
        int offlineMaxMessages = data.getInt("maxOfflineMessages", 5000);
        this.client = new LogseneClient(receiverUrl, appToken);
        try {
            this.worker = new LogWorker((Context)this, this.client, appToken, type, offlineMaxMessages);
        }
        catch (IOException e) {
            Log.e((String)this.TAG, (String)"Cannot initialize log worker", (Throwable)e);
            this.stopSelf();
        }
    }

    public void onCreate() {
        Log.d((String)this.TAG, (String)"Logsene service starting");
        ComponentName myService = new ComponentName((Context)this, ((Object)((Object)this)).getClass());
        Bundle data = null;
        try {
            data = this.getPackageManager().getServiceInfo((ComponentName)myService, (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.config(data);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        String jsonString;
        if (intent != null && (jsonString = intent.getStringExtra("obj")) != null) {
            try {
                JSONObject obj = new JSONObject(jsonString);
                this.worker.addToQueue(obj);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return 1;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }
}

