/*
 * Decompiled with CFR 0.152.
 */
package com.sematext.android;

import com.sematext.android.Logsene;
import com.sematext.android.Utils;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.json.JSONException;
import org.json.JSONObject;

public class LogseneHandler
extends Handler {
    private final Logsene logsene;

    public LogseneHandler(Logsene logsene) {
        this.logsene = logsene;
        this.setFormatter(new SimpleFormatter());
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        JSONObject obj = new JSONObject();
        try {
            obj.put("@timestamp", (Object)Utils.iso8601(record.getMillis()));
            obj.put("level", (Object)record.getLevel().toString());
            obj.put("message", (Object)this.getFormatter().formatMessage(record));
            obj.put("logger", (Object)record.getLoggerName());
            obj.put("seqNum", record.getSequenceNumber());
            obj.put("threadId", record.getThreadID());
            obj.put("sourceClass", (Object)record.getSourceClassName());
            obj.put("sourceMethod", (Object)record.getSourceMethodName());
            if (record.getThrown() != null) {
                obj.put("stacktrace", (Object)Utils.getStackTrace(record.getThrown()));
            }
            this.logsene.event(obj);
        }
        catch (JSONException e) {
            this.reportError("Unable to construct json object", (Exception)((Object)e), 0);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

