/*
 * Decompiled with CFR 0.152.
 */
package com.sematext.android;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.sematext.android.Installation;
import com.sematext.android.LogseneService;
import com.sematext.android.Utils;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class Logsene {
    private final String TAG = this.getClass().getSimpleName();
    private static JSONObject defaultMeta;
    private final Context context;
    private String versionName;
    private Integer versionCode;
    private String uuid;

    public Logsene(Context context) {
        Utils.requireNonNull(context);
        this.context = context;
        this.uuid = Installation.id(context);
    }

    public void log(String level, String message) {
        Utils.requireNonNull(message);
        JSONObject obj = new JSONObject();
        try {
            obj.put("level", (Object)level);
            obj.put("message", (Object)message);
            this.sendServiceIntent(obj);
        }
        catch (JSONException e) {
            Log.e((String)this.TAG, (String)"Failed to construct json object", (Throwable)e);
        }
    }

    public void debug(String message) {
        this.log("debug", message);
    }

    public void info(String message) {
        this.log("info", message);
    }

    public void warn(String message) {
        this.log("warn", message);
    }

    public void warn(Throwable error) {
        this.log("warn", error);
    }

    public void error(String message) {
        this.log("error", message);
    }

    public void error(Throwable error) {
        this.log("error", error);
    }

    public void log(String level, Throwable error) {
        Utils.requireNonNull(error);
        JSONObject obj = new JSONObject();
        try {
            obj.put("level", (Object)level);
            obj.put("exception", (Object)error.getClass().toString());
            obj.put("message", (Object)error.getMessage());
            obj.put("stacktrace", (Object)Utils.getStackTrace(error));
            this.sendServiceIntent(obj);
        }
        catch (JSONException e) {
            Log.e((String)this.TAG, (String)"Failed to construct json object", (Throwable)e);
        }
    }

    public void event(JSONObject object) {
        Utils.requireNonNull(object);
        this.sendServiceIntent(object);
    }

    public static void setDefaultMeta(JSONObject metadata) {
        defaultMeta = metadata;
    }

    private void sendServiceIntent(JSONObject obj) {
        assert (obj != null);
        this.enrich(obj);
        Intent intent = new Intent(this.context, LogseneService.class);
        intent.putExtra("obj", obj.toString());
        this.context.startService(intent);
    }

    private String getVersionName() {
        if (this.versionName == null) {
            PackageInfo pInfo = null;
            try {
                pInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
                this.versionName = pInfo.versionName;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)this.TAG, (String)e.getMessage(), (Throwable)e);
                this.versionName = "n/a";
            }
        }
        return this.versionName;
    }

    private int getVersionCode() {
        if (this.versionCode == null) {
            PackageInfo pInfo = null;
            try {
                pInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
                this.versionCode = pInfo.versionCode;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)this.TAG, (String)e.getMessage(), (Throwable)e);
                this.versionCode = -1;
            }
        }
        return this.versionCode;
    }

    private void enrich(JSONObject obj) {
        assert (obj != null);
        try {
            if (!obj.has("@timestamp")) {
                obj.put("@timestamp", (Object)Utils.iso8601());
            }
            if (!obj.has("meta")) {
                JSONObject metadata = new JSONObject();
                metadata.put("versionName", (Object)this.getVersionName());
                metadata.put("versionCode", this.getVersionCode());
                metadata.put("osRelease", (Object)Build.VERSION.RELEASE);
                metadata.put("uuid", (Object)this.uuid);
                if (defaultMeta != null) {
                    Iterator keys = defaultMeta.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        metadata.put(key, defaultMeta.get(key));
                    }
                }
                obj.put("meta", (Object)metadata);
            }
        }
        catch (JSONException e) {
            Log.e((String)this.TAG, (String)"Failed to construct json object", (Throwable)e);
        }
    }
}

