/*
 * Decompiled with CFR 0.152.
 */
package com.gkemon.XMLtoPDF;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.pdf.PdfDocument;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.StrictMode;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.core.content.ContextCompat;
import com.gkemon.XMLtoPDF.PdfGeneratorListener;
import com.gkemon.XMLtoPDF.Utils;
import com.gkemon.XMLtoPDF.model.FailureResponse;
import com.gkemon.XMLtoPDF.model.SuccessResponse;
import com.karumi.dexter.Dexter;
import com.karumi.dexter.PermissionToken;
import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.PermissionGrantedResponse;
import com.karumi.dexter.listener.PermissionRequest;
import com.karumi.dexter.listener.single.PermissionListener;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PdfGenerator {
    public static double postScriptThreshold = 0.75;
    public static int a4HeightInPX = 3508;
    public static int a4WidthInPX = 2480;
    public static int a5HeightInPX = 1748;
    public static int a5WidthInPX = 2480;
    public static int a4HeightInPostScript = (int)((double)a4HeightInPX * postScriptThreshold);
    public static int a4WidthInPostScript = (int)((double)a4WidthInPX * postScriptThreshold);
    public static int WRAP_CONTENT_WIDTH = 0;
    public static int WRAP_CONTENT_HEIGHT = 0;

    public static ContextStep getBuilder() {
        return new Builder();
    }

    public static class Builder
    implements Build,
    FileNameStep,
    PageSizeStep,
    LayoutXMLSourceIntakeStep,
    ViewSourceIntakeStep,
    ViewIDSourceIntakeStep,
    FromSourceStep,
    ContextStep {
        private static int NO_XML_SELECTED_YET = -1;
        private int pageWidthInPixel = a4WidthInPX;
        private int pageHeightInPixel = a4HeightInPX;
        private Context context;
        private PageSize pageSize;
        private PdfGeneratorListener pdfGeneratorListener;
        private List<View> viewList = new ArrayList<View>();
        private String fileName;
        private String targetPdf;
        private boolean openPdfFile = true;
        private String folderName;
        private String directory_path;
        private Disposable disposable;

        private void postFailure(String errorMessage) {
            FailureResponse failureResponse = new FailureResponse(errorMessage);
            this.postLog(errorMessage);
            if (this.pdfGeneratorListener != null) {
                this.pdfGeneratorListener.onFailure(failureResponse);
            }
        }

        private void postFailure(Throwable throwable) {
            FailureResponse failureResponse = new FailureResponse(throwable);
            if (this.pdfGeneratorListener != null) {
                this.pdfGeneratorListener.onFailure(failureResponse);
            }
        }

        private void postLog(String logMessage) {
            if (this.pdfGeneratorListener != null) {
                this.pdfGeneratorListener.showLog(logMessage);
            }
        }

        private void postOnGenerationStart() {
            if (this.pdfGeneratorListener != null) {
                this.pdfGeneratorListener.onStartPDFGeneration();
            }
        }

        private void postOnGenerationFinished() {
            if (this.pdfGeneratorListener != null) {
                this.pdfGeneratorListener.onFinishPDFGeneration();
            }
        }

        private void postSuccess(PdfDocument pdfDocument, File file, int widthInPS, int heightInPS) {
            if (this.pdfGeneratorListener != null) {
                this.pdfGeneratorListener.onSuccess(new SuccessResponse(pdfDocument, file, widthInPS, heightInPS));
            }
        }

        private void openGeneratedPDF() {
            File file = new File(this.targetPdf);
            if (file.exists()) {
                Intent intent = new Intent("android.intent.action.VIEW");
                Uri uri = Uri.fromFile((File)file);
                intent.setDataAndType(uri, "*/*");
                intent.setFlags(0x4000000);
                try {
                    this.context.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    this.postFailure(e);
                }
            } else {
                String path = TextUtils.isEmpty((CharSequence)this.directory_path) ? "null" : this.directory_path;
                this.postFailure("PDF file is not existing in storage. Your Generated path is " + path);
            }
        }

        private void print() {
            try {
                if (this.context != null) {
                    PdfDocument document = new PdfDocument();
                    if (this.pageSize != null) {
                        if (this.pageSize == PageSize.A4) {
                            this.pageHeightInPixel = a4HeightInPX;
                            this.pageWidthInPixel = a4WidthInPX;
                        } else if (this.pageSize == PageSize.A5) {
                            this.pageHeightInPixel = a5HeightInPX;
                            this.pageWidthInPixel = a5WidthInPX;
                        } else if (this.pageSize == PageSize.WRAP_CONTENT) {
                            this.pageWidthInPixel = WRAP_CONTENT_WIDTH;
                            this.pageHeightInPixel = WRAP_CONTENT_HEIGHT;
                        }
                    } else {
                        this.postLog("Default page size is not found. Your custom page width is " + this.pageWidthInPixel + " and custom page height is " + this.pageHeightInPixel);
                    }
                    if (this.viewList == null || this.viewList.size() == 0) {
                        this.postLog("View list null or zero sized");
                    }
                    for (int i = 0; i < this.viewList.size(); ++i) {
                        View content = this.viewList.get(i);
                        if (this.pageWidthInPixel == WRAP_CONTENT_WIDTH && this.pageHeightInPixel == WRAP_CONTENT_HEIGHT) {
                            content.measure(0, 0);
                            this.pageHeightInPixel = content.getMeasuredHeight();
                            this.pageWidthInPixel = content.getMeasuredWidth();
                            postScriptThreshold = 1.0;
                            a4HeightInPostScript = this.pageHeightInPixel;
                        }
                        this.pageHeightInPixel = (int)((double)this.pageHeightInPixel * postScriptThreshold);
                        this.pageWidthInPixel = (int)((double)this.pageWidthInPixel * postScriptThreshold);
                        content.measure(View.MeasureSpec.makeMeasureSpec((int)this.pageWidthInPixel, (int)0x40000000), 0);
                        this.pageHeightInPixel = Math.max(content.getMeasuredHeight(), a4HeightInPostScript);
                        PdfDocument.PageInfo pageInfo = new PdfDocument.PageInfo.Builder(this.pageWidthInPixel, this.pageHeightInPixel, i + 1).create();
                        PdfDocument.Page page = document.startPage(pageInfo);
                        content.layout(0, 0, this.pageWidthInPixel, this.pageHeightInPixel);
                        content.draw(page.getCanvas());
                        document.finishPage(page);
                        content.invalidate();
                        content.requestLayout();
                    }
                    StrictMode.VmPolicy.Builder builder = new StrictMode.VmPolicy.Builder();
                    StrictMode.setVmPolicy((StrictMode.VmPolicy)builder.build());
                    this.setUpDirectoryPath(this.context);
                    if (TextUtils.isEmpty((CharSequence)this.directory_path)) {
                        this.postFailure("Environment.getExternalStorageDirectory() and context.getExternalFilesDir() is returning null");
                        return;
                    }
                    this.directory_path = this.directory_path + "/" + this.folderName + "/";
                    File file = new File(this.directory_path);
                    if (!file.exists() && !file.mkdirs()) {
                        this.postLog("Folder is not created.file.mkdirs() is returning false");
                    }
                    this.targetPdf = this.directory_path + this.fileName + ".pdf";
                    File filePath = new File(this.targetPdf);
                    this.disposeDisposable();
                    this.postOnGenerationStart();
                    this.disposable = Completable.fromAction(() -> document.writeTo((OutputStream)new FileOutputStream(filePath))).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).doFinally(() -> {
                        document.close();
                        this.disposeDisposable();
                        this.postOnGenerationFinished();
                    }).subscribe(() -> {
                        this.postSuccess(document, filePath, this.pageWidthInPixel, this.pageHeightInPixel);
                        document.close();
                        if (this.openPdfFile) {
                            this.openGeneratedPDF();
                        }
                    }, this::postFailure);
                } else {
                    this.postFailure("Context is null");
                }
            }
            catch (Exception e) {
                this.postFailure(e);
            }
        }

        private void disposeDisposable() {
            if (this.disposable != null && !this.disposable.isDisposed()) {
                this.disposable.dispose();
            }
        }

        private void setUpDirectoryPath(Context context) {
            if (Environment.getExternalStorageDirectory() != null && !TextUtils.isEmpty((CharSequence)Environment.getExternalStorageDirectory().getPath())) {
                this.directory_path = Environment.getExternalStorageDirectory().getPath();
            }
            if ((Build.VERSION.SDK_INT >= 29 || TextUtils.isEmpty((CharSequence)this.directory_path)) && context.getExternalFilesDir(null) != null && !TextUtils.isEmpty((CharSequence)context.getExternalFilesDir(null).getAbsolutePath())) {
                this.directory_path = context.getExternalFilesDir(null).getAbsolutePath();
                this.postLog("Environment.getExternalStorageDirectory() is returning null or you are using Android API level 30+ which prevents to get external storage pathinstead of using storage scope. Using context.getExternalFilesDir(null) which is returning the absolute path - " + this.directory_path + "");
            }
        }

        @Override
        public void build(PdfGeneratorListener pdfGeneratorListener) {
            this.pdfGeneratorListener = pdfGeneratorListener;
            if (ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
                this.print();
            } else {
                this.postLog("WRITE_EXTERNAL_STORAGE Permission is not given. Permission taking popup (using https://github.com/Karumi/Dexter) is going to be shown");
                Dexter.withContext((Context)this.context).withPermission("android.permission.WRITE_EXTERNAL_STORAGE").withListener(new PermissionListener(){

                    public void onPermissionGranted(PermissionGrantedResponse permissionGrantedResponse) {
                        this.print();
                    }

                    public void onPermissionDenied(PermissionDeniedResponse permissionDeniedResponse) {
                        this.postLog("WRITE_EXTERNAL_STORAGE Permission is denied by user.");
                    }

                    public void onPermissionRationaleShouldBeShown(PermissionRequest permissionRequest, PermissionToken permissionToken) {
                    }
                }).withErrorListener(error -> this.postLog("Error from Dexter (https://github.com/Karumi/Dexter) : " + error.toString())).check();
            }
        }

        @Override
        public PageSizeStep fromView(View ... viewArrays) {
            this.viewList = new ArrayList<View>(Arrays.asList(viewArrays));
            return this;
        }

        @Override
        public PageSizeStep fromViewList(List<View> viewList) {
            this.viewList = viewList;
            return this;
        }

        @Override
        public Build openPDFafterGeneration(boolean openPdfFile) {
            this.openPdfFile = openPdfFile;
            return this;
        }

        @Override
        public FromSourceStep setContext(Context context) {
            this.context = context;
            return this;
        }

        @Override
        public FileNameStep setPageSize(PageSize pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public Build setFolderName(String folderName) {
            this.folderName = folderName;
            return this;
        }

        @Override
        public Build setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        @Override
        public PageSizeStep fromViewID(Activity activity, Integer ... viewIDs) {
            this.viewList = Utils.getViewListFromID(activity, Arrays.asList(viewIDs));
            return this;
        }

        @Override
        public PageSizeStep fromViewIDList(Activity activity, List<Integer> viewIDList) {
            this.viewList = Utils.getViewListFromID(activity, viewIDList);
            return this;
        }

        @Override
        public PageSizeStep fromLayoutXML(Integer ... layouts) {
            this.viewList = Utils.getViewListFromLayout(this.context, this.pdfGeneratorListener, Arrays.asList(layouts));
            return this;
        }

        @Override
        public PageSizeStep fromLayoutXMLList(@LayoutRes List<Integer> layoutXMLList) {
            this.viewList = Utils.getViewListFromLayout(this.context, this.pdfGeneratorListener, layoutXMLList);
            return this;
        }

        @Override
        public LayoutXMLSourceIntakeStep fromLayoutXMLSource() {
            return this;
        }

        @Override
        public ViewIDSourceIntakeStep fromViewIDSource() {
            return this;
        }

        @Override
        public ViewSourceIntakeStep fromViewSource() {
            return this;
        }
    }

    public static interface Build {
        public void build(PdfGeneratorListener var1);

        public Build setFolderName(String var1);

        public Build openPDFafterGeneration(boolean var1);
    }

    public static interface FileNameStep {
        public Build setFileName(String var1);
    }

    public static interface PageSizeStep {
        public FileNameStep setPageSize(PageSize var1);
    }

    public static interface ViewIDSourceIntakeStep {
        public PageSizeStep fromViewID(Activity var1, Integer ... var2);

        public PageSizeStep fromViewIDList(Activity var1, @IdRes List<Integer> var2);
    }

    public static interface LayoutXMLSourceIntakeStep {
        public PageSizeStep fromLayoutXML(Integer ... var1);

        public PageSizeStep fromLayoutXMLList(@LayoutRes List<Integer> var1);
    }

    public static interface ViewSourceIntakeStep {
        public PageSizeStep fromView(View ... var1);

        public PageSizeStep fromViewList(List<View> var1);
    }

    public static interface FromSourceStep {
        public LayoutXMLSourceIntakeStep fromLayoutXMLSource();

        public ViewIDSourceIntakeStep fromViewIDSource();

        public ViewSourceIntakeStep fromViewSource();
    }

    public static interface ContextStep {
        public FromSourceStep setContext(Context var1);
    }

    public static enum PageSize {
        A4,
        A5,
        WRAP_CONTENT;

    }
}

