/*
 * Decompiled with CFR 0.152.
 */
package com.gkemon.XMLtoPDF;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.pdf.PdfDocument;
import android.net.Uri;
import android.os.Environment;
import android.os.StrictMode;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.core.content.ContextCompat;
import com.gkemon.XMLtoPDF.PdfGeneratorListener;
import com.gkemon.XMLtoPDF.Utils;
import com.gkemon.XMLtoPDF.model.FailureResponse;
import com.gkemon.XMLtoPDF.model.SuccessResponse;
import com.karumi.dexter.Dexter;
import com.karumi.dexter.PermissionToken;
import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.PermissionGrantedResponse;
import com.karumi.dexter.listener.PermissionRequest;
import com.karumi.dexter.listener.single.PermissionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PdfGenerator {
    public static int a4HeightInPX = 3508;
    public static int a4WidthInPX = 2480;
    public static int a5HeightInPX = 1748;
    public static int a5WidthInPX = 2480;

    public static ContextStep getBuilder() {
        return new Builder();
    }

    public static class Builder
    implements Build,
    FileNameStep,
    PageSizeStep,
    LayoutXMLSourceIntakeStep,
    ViewSourceIntakeStep,
    ViewIDSourceIntakeStep,
    FromSourceStep,
    ContextStep {
        private static int NO_XML_SELECTED_YET = -1;
        private int pageWidthInPixel;
        private int pageHeightInPixel;
        private Context context;
        private PageSize pageSize;
        private PdfGeneratorListener pdfGeneratorListener;
        private List<View> viewList = new ArrayList<View>();
        private String fileName;
        private String targetPdf;
        private boolean openPdfFile = true;
        private String folderName;
        private String directory_path;

        private void postFailure(String errorMessage) {
            FailureResponse failureResponse = new FailureResponse(errorMessage);
            this.postLog(errorMessage);
            if (this.pdfGeneratorListener != null) {
                this.pdfGeneratorListener.onFailure(failureResponse);
            }
        }

        private void postFailure(Throwable throwable) {
            FailureResponse failureResponse = new FailureResponse(throwable);
            if (this.pdfGeneratorListener != null) {
                this.pdfGeneratorListener.onFailure(failureResponse);
            }
        }

        private void postLog(String logMessage) {
            if (this.pdfGeneratorListener != null) {
                this.pdfGeneratorListener.showLog(logMessage);
            }
        }

        private void postSuccess(PdfDocument pdfDocument, File file) {
            if (this.pdfGeneratorListener != null) {
                this.pdfGeneratorListener.onSuccess(new SuccessResponse(pdfDocument, file));
            }
        }

        private void openGeneratedPDF() {
            File file = new File(this.targetPdf);
            if (file.exists()) {
                Intent intent = new Intent("android.intent.action.VIEW");
                Uri uri = Uri.fromFile((File)file);
                intent.setDataAndType(uri, "*/*");
                intent.setFlags(0x4000000);
                try {
                    this.context.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    this.postFailure(e);
                }
            } else {
                String path = TextUtils.isEmpty((CharSequence)this.directory_path) ? "null" : this.directory_path;
                this.postFailure("PDF file is not existing in storage. Your Generated path is " + path);
            }
        }

        private void print() {
            block17: {
                try {
                    if (this.context != null) {
                        PdfDocument document = new PdfDocument();
                        if (this.pageSize != null) {
                            if (this.pageSize == PageSize.A4) {
                                this.pageHeightInPixel = a4HeightInPX;
                                this.pageWidthInPixel = a4WidthInPX;
                            } else if (this.pageSize == PageSize.A5) {
                                this.pageHeightInPixel = a5HeightInPX;
                                this.pageWidthInPixel = a5WidthInPX;
                            }
                        }
                        if (this.viewList == null || this.viewList.size() == 0) {
                            this.postLog("View list null or zero sized");
                        }
                        for (int i = 0; i < this.viewList.size(); ++i) {
                            PdfDocument.PageInfo pageInfo = new PdfDocument.PageInfo.Builder(this.pageWidthInPixel, this.pageHeightInPixel, i + 1).create();
                            PdfDocument.Page page = document.startPage(pageInfo);
                            View content = this.viewList.get(i);
                            content.measure(this.pageWidthInPixel, this.pageHeightInPixel);
                            content.layout(0, 0, this.pageWidthInPixel, this.pageHeightInPixel);
                            int measureWidth = View.MeasureSpec.makeMeasureSpec((int)page.getCanvas().getWidth(), (int)0x40000000);
                            int measuredHeight = View.MeasureSpec.makeMeasureSpec((int)page.getCanvas().getHeight(), (int)0x40000000);
                            content.measure(measureWidth, measuredHeight);
                            content.layout(0, 0, page.getCanvas().getWidth(), page.getCanvas().getHeight());
                            content.draw(page.getCanvas());
                            document.finishPage(page);
                        }
                        StrictMode.VmPolicy.Builder builder = new StrictMode.VmPolicy.Builder();
                        StrictMode.setVmPolicy((StrictMode.VmPolicy)builder.build());
                        if (Environment.getExternalStorageDirectory() != null && !TextUtils.isEmpty((CharSequence)Environment.getExternalStorageDirectory().getPath())) {
                            this.directory_path = Environment.getExternalStorageDirectory().getPath();
                        } else if (this.context.getExternalFilesDir(null) != null && !TextUtils.isEmpty((CharSequence)this.context.getExternalFilesDir(null).getAbsolutePath())) {
                            this.postLog("Environment.getExternalStorageDirectory() is returning null");
                            this.directory_path = this.context.getExternalFilesDir(null).getAbsolutePath();
                        }
                        if (TextUtils.isEmpty((CharSequence)this.directory_path)) {
                            this.postFailure("Environment.getExternalStorageDirectory() and context.getExternalFilesDir() is returning null");
                            return;
                        }
                        this.directory_path = this.directory_path + "/" + this.folderName + "/";
                        File file = new File(this.directory_path);
                        if (!file.exists() && !file.mkdirs()) {
                            this.postLog("Folder is not created.file.mkdirs() is returning false");
                        }
                        this.targetPdf = this.directory_path + this.fileName + ".pdf";
                        File filePath = new File(this.targetPdf);
                        try {
                            document.writeTo((OutputStream)new FileOutputStream(filePath));
                            this.postSuccess(document, filePath);
                        }
                        catch (IOException e) {
                            this.postFailure(e);
                        }
                        document.close();
                        if (this.openPdfFile) {
                            this.openGeneratedPDF();
                        }
                        break block17;
                    }
                    this.postFailure("Context is null");
                }
                catch (Exception e) {
                    this.postFailure(e);
                }
            }
        }

        @Override
        public void build(PdfGeneratorListener pdfGeneratorListener) {
            this.pdfGeneratorListener = pdfGeneratorListener;
            if (ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
                this.print();
            } else {
                Dexter.withContext((Context)this.context).withPermission("android.permission.WRITE_EXTERNAL_STORAGE").withListener(new PermissionListener(){

                    public void onPermissionGranted(PermissionGrantedResponse permissionGrantedResponse) {
                        Builder.this.print();
                    }

                    public void onPermissionDenied(PermissionDeniedResponse permissionDeniedResponse) {
                    }

                    public void onPermissionRationaleShouldBeShown(PermissionRequest permissionRequest, PermissionToken permissionToken) {
                    }
                }).check();
            }
        }

        @Override
        public PageSizeStep fromView(View ... viewArrays) {
            this.viewList = new ArrayList<View>(Arrays.asList(viewArrays));
            return this;
        }

        @Override
        public PageSizeStep fromViewList(List<View> viewList) {
            this.viewList = viewList;
            return this;
        }

        @Override
        public Build openPDFafterGeneration(boolean openPdfFile) {
            this.openPdfFile = openPdfFile;
            return this;
        }

        @Override
        public FromSourceStep setContext(Context context) {
            this.context = context;
            return this;
        }

        @Override
        public FileNameStep setDefaultPageSize(PageSize pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public FileNameStep setCustomPageSize(int widthInPX, int heightInPX) {
            this.pageWidthInPixel = widthInPX;
            this.pageHeightInPixel = heightInPX;
            return this;
        }

        @Override
        public Build setFolderName(String folderName) {
            this.folderName = folderName;
            return this;
        }

        @Override
        public Build setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        @Override
        public PageSizeStep fromViewID(Activity activity, Integer ... viewIDs) {
            this.viewList = Utils.getViewListFromID(activity, Arrays.asList(viewIDs));
            return this;
        }

        @Override
        public PageSizeStep fromViewIDList(Activity activity, List<Integer> viewIDList) {
            this.viewList = Utils.getViewListFromID(activity, viewIDList);
            return this;
        }

        @Override
        public PageSizeStep fromLayoutXML(Integer ... layouts) {
            this.viewList = Utils.getViewListFromLayout(this.context, this.pdfGeneratorListener, Arrays.asList(layouts));
            return this;
        }

        @Override
        public PageSizeStep fromLayoutXMLList(@LayoutRes List<Integer> layoutXMLList) {
            this.viewList = Utils.getViewListFromLayout(this.context, this.pdfGeneratorListener, layoutXMLList);
            return this;
        }

        @Override
        public LayoutXMLSourceIntakeStep fromLayoutXMLSource() {
            return this;
        }

        @Override
        public ViewIDSourceIntakeStep fromViewIDSource() {
            return this;
        }

        @Override
        public ViewSourceIntakeStep fromViewSource() {
            return this;
        }
    }

    public static interface Build {
        public void build(PdfGeneratorListener var1);

        public Build setFolderName(String var1);

        public Build openPDFafterGeneration(boolean var1);
    }

    public static interface FileNameStep {
        public Build setFileName(String var1);
    }

    public static interface PageSizeStep {
        public FileNameStep setDefaultPageSize(PageSize var1);

        public FileNameStep setCustomPageSize(int var1, int var2);
    }

    public static interface ViewIDSourceIntakeStep {
        public PageSizeStep fromViewID(Activity var1, Integer ... var2);

        public PageSizeStep fromViewIDList(Activity var1, @IdRes List<Integer> var2);
    }

    public static interface LayoutXMLSourceIntakeStep {
        public PageSizeStep fromLayoutXML(Integer ... var1);

        public PageSizeStep fromLayoutXMLList(@LayoutRes List<Integer> var1);
    }

    public static interface ViewSourceIntakeStep {
        public PageSizeStep fromView(View ... var1);

        public PageSizeStep fromViewList(List<View> var1);
    }

    public static interface FromSourceStep {
        public LayoutXMLSourceIntakeStep fromLayoutXMLSource();

        public ViewIDSourceIntakeStep fromViewIDSource();

        public ViewSourceIntakeStep fromViewSource();
    }

    public static interface ContextStep {
        public FromSourceStep setContext(Context var1);
    }

    public static enum PageSize {
        A4,
        A5;

    }
}

