/*
 * Decompiled with CFR 0.152.
 */
package com.zjy.pdfview.widget;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.zjy.pdfview.R;

public class ScrollSlider
extends LinearLayout {
    private float slideDownY;
    private ScrollSlideListener listener;

    public ScrollSlider(Context context) {
        this(context, null);
    }

    public ScrollSlider(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScrollSlider(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setOrientation(1);
        this.setBackgroundColor(Color.parseColor((String)"#7D000000"));
        this.setGravity(17);
        ImageView topArrow = new ImageView(this.getContext());
        topArrow.setImageResource(R.drawable.ic_top_arrow);
        this.addView((View)topArrow);
        ImageView bottomArrow = new ImageView(this.getContext());
        bottomArrow.setImageResource(R.drawable.ic_top_arrow);
        bottomArrow.setRotation(180.0f);
        this.addView((View)bottomArrow);
        ((LinearLayout.LayoutParams)bottomArrow.getLayoutParams()).topMargin = 20;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View childView = this.getChildAt(i);
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)childView.getLayoutParams();
            params.width = w / 2;
            params.height = h / 2;
            childView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.slideDownY = event.getY();
                return true;
            }
            case 2: {
                int scrollY = (int)(this.getY() + (event.getY() - this.slideDownY));
                if (this.listener != null) {
                    boolean canScroll = this.listener.scrolling(scrollY);
                    if (!canScroll) return true;
                }
                this.setTranslationY(scrollY);
                return true;
            }
        }
        return true;
    }

    public void setScrollSlideListener(ScrollSlideListener l) {
        this.listener = l;
    }

    public static interface ScrollSlideListener {
        public boolean scrolling(int var1);
    }
}

