/*
 * Decompiled with CFR 0.152.
 */
package com.zjy.pdfview.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;

public class LoadingView
extends View {
    private int strokeWidth;
    private int startColor;
    private int endColor;
    private int duration;
    private Paint paint;
    private float cx;
    private float cy;
    private float radius;
    private SweepGradient sweepGradient;

    public LoadingView(Context context) {
        super(context);
        this.init();
    }

    public LoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private int dp(int dp) {
        return (int)((float)dp * this.getResources().getDisplayMetrics().density + 0.5f);
    }

    private void init() {
        this.strokeWidth = this.dp(2);
        this.startColor = 0;
        this.endColor = Color.parseColor((String)"#d8d5d8");
        this.duration = 1200;
        this.paint = new Paint(1);
        this.paint.setStrokeWidth((float)this.strokeWidth);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeCap(Paint.Cap.ROUND);
        this.paint.setStrokeJoin(Paint.Join.ROUND);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.cx = (float)this.getMeasuredWidth() / 2.0f;
        this.cy = (float)this.getMeasuredHeight() / 2.0f;
        this.radius = (float)this.getMeasuredWidth() / 2.0f - (float)this.strokeWidth / 2.0f;
        this.sweepGradient = new SweepGradient(this.cx, this.cy, new int[]{this.startColor, this.endColor}, null);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.paint.setShader((Shader)this.sweepGradient);
        canvas.drawCircle(this.cx, this.cy, this.radius, this.paint);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        RotateAnimation animation = new RotateAnimation(0.0f, 359.0f, 1, 0.5f, 1, 0.5f);
        animation.setDuration((long)this.duration);
        animation.setRepeatCount(-1);
        animation.setInterpolator((Interpolator)new LinearInterpolator());
        this.startAnimation((Animation)animation);
    }

    protected void onDetachedFromWindow() {
        this.clearAnimation();
        super.onDetachedFromWindow();
    }
}

