/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ServerboundSetCommandMinecartPacket
implements MinecraftPacket {
    private final int entityId;
    @NonNull
    private final String command;
    private final boolean doesTrackOutput;

    public ServerboundSetCommandMinecartPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.entityId = helper.readVarInt(in);
        this.command = helper.readString(in);
        this.doesTrackOutput = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.entityId);
        helper.writeString(out, this.command);
        out.writeBoolean(this.doesTrackOutput);
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public String getCommand() {
        return this.command;
    }

    public boolean isDoesTrackOutput() {
        return this.doesTrackOutput;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSetCommandMinecartPacket)) {
            return false;
        }
        ServerboundSetCommandMinecartPacket other = (ServerboundSetCommandMinecartPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.isDoesTrackOutput() != other.isDoesTrackOutput()) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        return !(this$command == null ? other$command != null : !this$command.equals(other$command));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundSetCommandMinecartPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + (this.isDoesTrackOutput() ? 79 : 97);
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundSetCommandMinecartPacket(entityId=" + this.getEntityId() + ", command=" + this.getCommand() + ", doesTrackOutput=" + this.isDoesTrackOutput() + ")";
    }

    public ServerboundSetCommandMinecartPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerboundSetCommandMinecartPacket(entityId, this.command, this.doesTrackOutput);
    }

    public ServerboundSetCommandMinecartPacket withCommand(@NonNull String command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        return this.command == command ? this : new ServerboundSetCommandMinecartPacket(this.entityId, command, this.doesTrackOutput);
    }

    public ServerboundSetCommandMinecartPacket withDoesTrackOutput(boolean doesTrackOutput) {
        return this.doesTrackOutput == doesTrackOutput ? this : new ServerboundSetCommandMinecartPacket(this.entityId, this.command, doesTrackOutput);
    }

    public ServerboundSetCommandMinecartPacket(int entityId, @NonNull String command, boolean doesTrackOutput) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        this.entityId = entityId;
        this.command = command;
        this.doesTrackOutput = doesTrackOutput;
    }
}

