/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level.border;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class ClientboundSetBorderCenterPacket
implements MinecraftPacket {
    private final double newCenterX;
    private final double newCenterZ;

    public ClientboundSetBorderCenterPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.newCenterX = in.readDouble();
        this.newCenterZ = in.readDouble();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeDouble(this.newCenterX);
        out.writeDouble(this.newCenterZ);
    }

    public double getNewCenterX() {
        return this.newCenterX;
    }

    public double getNewCenterZ() {
        return this.newCenterZ;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetBorderCenterPacket)) {
            return false;
        }
        ClientboundSetBorderCenterPacket other = (ClientboundSetBorderCenterPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getNewCenterX(), other.getNewCenterX()) != 0) {
            return false;
        }
        return Double.compare(this.getNewCenterZ(), other.getNewCenterZ()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetBorderCenterPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $newCenterX = Double.doubleToLongBits(this.getNewCenterX());
        result = result * 59 + (int)($newCenterX >>> 32 ^ $newCenterX);
        long $newCenterZ = Double.doubleToLongBits(this.getNewCenterZ());
        result = result * 59 + (int)($newCenterZ >>> 32 ^ $newCenterZ);
        return result;
    }

    public String toString() {
        return "ClientboundSetBorderCenterPacket(newCenterX=" + this.getNewCenterX() + ", newCenterZ=" + this.getNewCenterZ() + ")";
    }

    public ClientboundSetBorderCenterPacket withNewCenterX(double newCenterX) {
        return this.newCenterX == newCenterX ? this : new ClientboundSetBorderCenterPacket(newCenterX, this.newCenterZ);
    }

    public ClientboundSetBorderCenterPacket withNewCenterZ(double newCenterZ) {
        return this.newCenterZ == newCenterZ ? this : new ClientboundSetBorderCenterPacket(this.newCenterX, newCenterZ);
    }

    public ClientboundSetBorderCenterPacket(double newCenterX, double newCenterZ) {
        this.newCenterX = newCenterX;
        this.newCenterZ = newCenterZ;
    }
}

