/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.entity.EntityEvent;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundEntityEventPacket
implements MinecraftPacket {
    private final int entityId;
    @NonNull
    private final EntityEvent event;

    public ClientboundEntityEventPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.entityId = in.readInt();
        this.event = helper.readEntityEvent(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeInt(this.entityId);
        helper.writeEntityEvent(out, this.event);
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public EntityEvent getEvent() {
        return this.event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundEntityEventPacket)) {
            return false;
        }
        ClientboundEntityEventPacket other = (ClientboundEntityEventPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        EntityEvent this$event = this.getEvent();
        EntityEvent other$event = other.getEvent();
        return !(this$event == null ? other$event != null : !((Object)((Object)this$event)).equals((Object)other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundEntityEventPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        EntityEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : ((Object)((Object)$event)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundEntityEventPacket(entityId=" + this.getEntityId() + ", event=" + this.getEvent() + ")";
    }

    public ClientboundEntityEventPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundEntityEventPacket(entityId, this.event);
    }

    public ClientboundEntityEventPacket withEvent(@NonNull EntityEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        return this.event == event ? this : new ClientboundEntityEventPacket(this.entityId, event);
    }

    public ClientboundEntityEventPacket(int entityId, @NonNull EntityEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.entityId = entityId;
        this.event = event;
    }
}

