/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class ClientboundServerDataPacket
implements MinecraftPacket {
    private final Component motd;
    private final byte @Nullable [] iconBytes;
    private final boolean enforcesSecureChat;

    public ClientboundServerDataPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.motd = helper.readComponent(in);
        this.iconBytes = helper.readNullable(in, helper::readByteArray);
        this.enforcesSecureChat = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeComponent(out, this.motd);
        helper.writeNullable(out, this.iconBytes, helper::writeByteArray);
        out.writeBoolean(this.enforcesSecureChat);
    }

    public Component getMotd() {
        return this.motd;
    }

    public byte @Nullable [] getIconBytes() {
        return this.iconBytes;
    }

    public boolean isEnforcesSecureChat() {
        return this.enforcesSecureChat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundServerDataPacket)) {
            return false;
        }
        ClientboundServerDataPacket other = (ClientboundServerDataPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnforcesSecureChat() != other.isEnforcesSecureChat()) {
            return false;
        }
        Component this$motd = this.getMotd();
        Component other$motd = other.getMotd();
        if (this$motd == null ? other$motd != null : !this$motd.equals(other$motd)) {
            return false;
        }
        return Arrays.equals(this.getIconBytes(), other.getIconBytes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundServerDataPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnforcesSecureChat() ? 79 : 97);
        Component $motd = this.getMotd();
        result = result * 59 + ($motd == null ? 43 : $motd.hashCode());
        result = result * 59 + Arrays.hashCode(this.getIconBytes());
        return result;
    }

    public String toString() {
        return "ClientboundServerDataPacket(motd=" + this.getMotd() + ", iconBytes=" + Arrays.toString(this.getIconBytes()) + ", enforcesSecureChat=" + this.isEnforcesSecureChat() + ")";
    }

    public ClientboundServerDataPacket withMotd(Component motd) {
        return this.motd == motd ? this : new ClientboundServerDataPacket(motd, this.iconBytes, this.enforcesSecureChat);
    }

    public ClientboundServerDataPacket withIconBytes(byte @Nullable [] iconBytes) {
        return this.iconBytes == iconBytes ? this : new ClientboundServerDataPacket(this.motd, iconBytes, this.enforcesSecureChat);
    }

    public ClientboundServerDataPacket withEnforcesSecureChat(boolean enforcesSecureChat) {
        return this.enforcesSecureChat == enforcesSecureChat ? this : new ClientboundServerDataPacket(this.motd, this.iconBytes, enforcesSecureChat);
    }

    public ClientboundServerDataPacket(Component motd, byte @Nullable [] iconBytes, boolean enforcesSecureChat) {
        this.motd = motd;
        this.iconBytes = iconBytes;
        this.enforcesSecureChat = enforcesSecureChat;
    }
}

