/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.entity.player.PlayerSpawnInfo;
import io.netty.buffer.ByteBuf;

public class ClientboundRespawnPacket
implements MinecraftPacket {
    private static final byte KEEP_ATTRIBUTES = 1;
    private static final byte KEEP_ENTITY_DATA = 2;
    private final PlayerSpawnInfo commonPlayerSpawnInfo;
    private final boolean keepMetadata;
    private final boolean keepAttributes;

    public ClientboundRespawnPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.commonPlayerSpawnInfo = helper.readPlayerSpawnInfo(in);
        byte dataToKeep = in.readByte();
        this.keepAttributes = (dataToKeep & 1) != 0;
        this.keepMetadata = (dataToKeep & 2) != 0;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writePlayerSpawnInfo(out, this.commonPlayerSpawnInfo);
        int dataToKeep = 0;
        if (this.keepMetadata) {
            dataToKeep = (byte)(dataToKeep + 2);
        }
        if (this.keepAttributes) {
            dataToKeep = (byte)(dataToKeep + 1);
        }
        out.writeByte(dataToKeep);
    }

    public PlayerSpawnInfo getCommonPlayerSpawnInfo() {
        return this.commonPlayerSpawnInfo;
    }

    public boolean isKeepMetadata() {
        return this.keepMetadata;
    }

    public boolean isKeepAttributes() {
        return this.keepAttributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundRespawnPacket)) {
            return false;
        }
        ClientboundRespawnPacket other = (ClientboundRespawnPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isKeepMetadata() != other.isKeepMetadata()) {
            return false;
        }
        if (this.isKeepAttributes() != other.isKeepAttributes()) {
            return false;
        }
        PlayerSpawnInfo this$commonPlayerSpawnInfo = this.getCommonPlayerSpawnInfo();
        PlayerSpawnInfo other$commonPlayerSpawnInfo = other.getCommonPlayerSpawnInfo();
        return !(this$commonPlayerSpawnInfo == null ? other$commonPlayerSpawnInfo != null : !((Object)this$commonPlayerSpawnInfo).equals(other$commonPlayerSpawnInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundRespawnPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isKeepMetadata() ? 79 : 97);
        result = result * 59 + (this.isKeepAttributes() ? 79 : 97);
        PlayerSpawnInfo $commonPlayerSpawnInfo = this.getCommonPlayerSpawnInfo();
        result = result * 59 + ($commonPlayerSpawnInfo == null ? 43 : ((Object)$commonPlayerSpawnInfo).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundRespawnPacket(commonPlayerSpawnInfo=" + this.getCommonPlayerSpawnInfo() + ", keepMetadata=" + this.isKeepMetadata() + ", keepAttributes=" + this.isKeepAttributes() + ")";
    }

    public ClientboundRespawnPacket withCommonPlayerSpawnInfo(PlayerSpawnInfo commonPlayerSpawnInfo) {
        return this.commonPlayerSpawnInfo == commonPlayerSpawnInfo ? this : new ClientboundRespawnPacket(commonPlayerSpawnInfo, this.keepMetadata, this.keepAttributes);
    }

    public ClientboundRespawnPacket withKeepMetadata(boolean keepMetadata) {
        return this.keepMetadata == keepMetadata ? this : new ClientboundRespawnPacket(this.commonPlayerSpawnInfo, keepMetadata, this.keepAttributes);
    }

    public ClientboundRespawnPacket withKeepAttributes(boolean keepAttributes) {
        return this.keepAttributes == keepAttributes ? this : new ClientboundRespawnPacket(this.commonPlayerSpawnInfo, this.keepMetadata, keepAttributes);
    }

    public ClientboundRespawnPacket(PlayerSpawnInfo commonPlayerSpawnInfo, boolean keepMetadata, boolean keepAttributes) {
        this.commonPlayerSpawnInfo = commonPlayerSpawnInfo;
        this.keepMetadata = keepMetadata;
        this.keepAttributes = keepAttributes;
    }
}

