/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.mc.auth.exception.request.RequestException;
import com.github.steveice10.mc.auth.service.SessionService;
import com.github.steveice10.mc.protocol.MinecraftProtocol;
import com.github.steveice10.mc.protocol.ServerLoginHandler;
import com.github.steveice10.mc.protocol.data.ProtocolState;
import com.github.steveice10.mc.protocol.data.status.PlayerInfo;
import com.github.steveice10.mc.protocol.data.status.ServerStatusInfo;
import com.github.steveice10.mc.protocol.data.status.VersionInfo;
import com.github.steveice10.mc.protocol.data.status.handler.ServerInfoBuilder;
import com.github.steveice10.mc.protocol.packet.common.clientbound.ClientboundDisconnectPacket;
import com.github.steveice10.mc.protocol.packet.common.clientbound.ClientboundKeepAlivePacket;
import com.github.steveice10.mc.protocol.packet.common.serverbound.ServerboundKeepAlivePacket;
import com.github.steveice10.mc.protocol.packet.configuration.clientbound.ClientboundFinishConfigurationPacket;
import com.github.steveice10.mc.protocol.packet.configuration.clientbound.ClientboundRegistryDataPacket;
import com.github.steveice10.mc.protocol.packet.configuration.serverbound.ServerboundFinishConfigurationPacket;
import com.github.steveice10.mc.protocol.packet.handshake.serverbound.ClientIntentionPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.ServerboundConfigurationAcknowledgedPacket;
import com.github.steveice10.mc.protocol.packet.login.clientbound.ClientboundGameProfilePacket;
import com.github.steveice10.mc.protocol.packet.login.clientbound.ClientboundHelloPacket;
import com.github.steveice10.mc.protocol.packet.login.clientbound.ClientboundLoginCompressionPacket;
import com.github.steveice10.mc.protocol.packet.login.clientbound.ClientboundLoginDisconnectPacket;
import com.github.steveice10.mc.protocol.packet.login.serverbound.ServerboundHelloPacket;
import com.github.steveice10.mc.protocol.packet.login.serverbound.ServerboundKeyPacket;
import com.github.steveice10.mc.protocol.packet.login.serverbound.ServerboundLoginAcknowledgedPacket;
import com.github.steveice10.mc.protocol.packet.status.clientbound.ClientboundPongResponsePacket;
import com.github.steveice10.mc.protocol.packet.status.clientbound.ClientboundStatusResponsePacket;
import com.github.steveice10.mc.protocol.packet.status.serverbound.ServerboundPingRequestPacket;
import com.github.steveice10.mc.protocol.packet.status.serverbound.ServerboundStatusRequestPacket;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.packetlib.Session;
import com.github.steveice10.packetlib.event.session.ConnectedEvent;
import com.github.steveice10.packetlib.event.session.DisconnectingEvent;
import com.github.steveice10.packetlib.event.session.SessionAdapter;
import com.github.steveice10.packetlib.packet.Packet;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import javax.crypto.SecretKey;
import net.kyori.adventure.text.Component;

public class ServerListener
extends SessionAdapter {
    private static final int DEFAULT_COMPRESSION_THRESHOLD = 256;
    private static final String SERVER_ID = "";
    private static final KeyPair KEY_PAIR;
    private final CompoundTag networkCodec;
    private final byte[] challenge = new byte[4];
    private String username = "";
    private long lastPingTime = 0L;
    private int lastPingId = 0;

    public ServerListener(CompoundTag networkCodec) {
        this.networkCodec = networkCodec;
        new Random().nextBytes(this.challenge);
    }

    @Override
    public void connected(ConnectedEvent event) {
        event.getSession().setFlag("ping", 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void packetReceived(Session session, Packet packet) {
        MinecraftProtocol protocol = (MinecraftProtocol)session.getPacketProtocol();
        if (protocol.getState() == ProtocolState.HANDSHAKE) {
            if (!(packet instanceof ClientIntentionPacket)) return;
            ClientIntentionPacket intentionPacket = (ClientIntentionPacket)packet;
            switch (intentionPacket.getIntent()) {
                case STATUS: {
                    protocol.setState(ProtocolState.STATUS);
                    return;
                }
                case LOGIN: {
                    protocol.setState(ProtocolState.LOGIN);
                    if (intentionPacket.getProtocolVersion() > protocol.getCodec().getProtocolVersion()) {
                        session.disconnect("Outdated server! I'm still on " + protocol.getCodec().getMinecraftVersion() + ".");
                        return;
                    }
                    if (intentionPacket.getProtocolVersion() >= protocol.getCodec().getProtocolVersion()) return;
                    session.disconnect("Outdated client! Please use " + protocol.getCodec().getMinecraftVersion() + ".");
                    return;
                }
                default: {
                    throw new UnsupportedOperationException("Invalid client intent: " + intentionPacket.getIntent());
                }
            }
        } else if (protocol.getState() == ProtocolState.LOGIN) {
            if (packet instanceof ServerboundHelloPacket) {
                this.username = ((ServerboundHelloPacket)packet).getUsername();
                if (session.getFlag("verify-users", true).booleanValue()) {
                    session.send(new ClientboundHelloPacket(SERVER_ID, KEY_PAIR.getPublic(), this.challenge));
                    return;
                } else {
                    new Thread(new UserAuthTask(session, null)).start();
                }
                return;
            } else if (packet instanceof ServerboundKeyPacket) {
                ServerboundKeyPacket keyPacket = (ServerboundKeyPacket)packet;
                PrivateKey privateKey = KEY_PAIR.getPrivate();
                if (!Arrays.equals(this.challenge, keyPacket.getEncryptedChallenge(privateKey))) {
                    session.disconnect("Invalid challenge!");
                    return;
                }
                SecretKey key = keyPacket.getSecretKey(privateKey);
                session.enableEncryption(protocol.enableEncryption(key));
                new Thread(new UserAuthTask(session, key)).start();
                return;
            } else {
                if (!(packet instanceof ServerboundLoginAcknowledgedPacket)) return;
                ((MinecraftProtocol)session.getPacketProtocol()).setState(ProtocolState.CONFIGURATION);
                session.send(new ClientboundRegistryDataPacket(this.networkCodec));
                session.send(new ClientboundFinishConfigurationPacket());
            }
            return;
        } else if (protocol.getState() == ProtocolState.STATUS) {
            if (packet instanceof ServerboundStatusRequestPacket) {
                ServerInfoBuilder builder = (ServerInfoBuilder)session.getFlag("info-builder");
                if (builder == null) {
                    builder = $ -> new ServerStatusInfo(new VersionInfo(protocol.getCodec().getMinecraftVersion(), protocol.getCodec().getProtocolVersion()), new PlayerInfo(0, 20, new ArrayList<GameProfile>()), (Component)Component.text((String)"A Minecraft Server"), null, false);
                }
                ServerStatusInfo info = builder.buildInfo(session);
                session.send(new ClientboundStatusResponsePacket(info));
                return;
            } else {
                if (!(packet instanceof ServerboundPingRequestPacket)) return;
                session.send(new ClientboundPongResponsePacket(((ServerboundPingRequestPacket)packet).getPingTime()));
            }
            return;
        } else if (protocol.getState() == ProtocolState.GAME) {
            if (packet instanceof ServerboundKeepAlivePacket) {
                if (((ServerboundKeepAlivePacket)packet).getPingId() != (long)this.lastPingId) return;
                long time = System.currentTimeMillis() - this.lastPingTime;
                session.setFlag("ping", time);
                return;
            } else if (packet instanceof ServerboundConfigurationAcknowledgedPacket) {
                protocol.setState(ProtocolState.CONFIGURATION);
                return;
            } else {
                if (!(packet instanceof ServerboundPingRequestPacket)) return;
                session.send(new ClientboundPongResponsePacket(((ServerboundPingRequestPacket)packet).getPingTime()));
            }
            return;
        } else {
            if (protocol.getState() != ProtocolState.CONFIGURATION || !(packet instanceof ServerboundFinishConfigurationPacket)) return;
            protocol.setState(ProtocolState.GAME);
            ServerLoginHandler handler = (ServerLoginHandler)session.getFlag("login-handler");
            if (handler != null) {
                handler.loggedIn(session);
            }
            if (!session.getFlag("manage-keep-alive", true).booleanValue()) return;
            new Thread(new KeepAliveTask(session)).start();
        }
    }

    @Override
    public void packetSent(Session session, Packet packet) {
        if (packet instanceof ClientboundLoginCompressionPacket) {
            session.setCompressionThreshold(((ClientboundLoginCompressionPacket)packet).getThreshold(), true);
            session.send(new ClientboundGameProfilePacket((GameProfile)session.getFlag("profile")));
        }
    }

    @Override
    public void disconnecting(DisconnectingEvent event) {
        MinecraftProtocol protocol = (MinecraftProtocol)event.getSession().getPacketProtocol();
        if (protocol.getState() == ProtocolState.LOGIN) {
            event.getSession().send(new ClientboundLoginDisconnectPacket(event.getReason()));
        } else if (protocol.getState() == ProtocolState.GAME) {
            event.getSession().send(new ClientboundDisconnectPacket(event.getReason()));
        }
    }

    static {
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            gen.initialize(1024);
            KEY_PAIR = gen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to generate server key pair.", e);
        }
    }

    private class UserAuthTask
    implements Runnable {
        private Session session;
        private SecretKey key;

        public UserAuthTask(Session session, SecretKey key) {
            this.key = key;
            this.session = session;
        }

        @Override
        public void run() {
            GameProfile profile;
            if (this.key != null) {
                SessionService sessionService = this.session.getFlag("session-service", new SessionService());
                try {
                    profile = sessionService.getProfileByServer(ServerListener.this.username, sessionService.getServerId(ServerListener.SERVER_ID, KEY_PAIR.getPublic(), this.key));
                }
                catch (RequestException e) {
                    this.session.disconnect("Failed to make session service request.", (Throwable)e);
                    return;
                }
                if (profile == null) {
                    this.session.disconnect("Failed to verify username.");
                }
            } else {
                profile = new GameProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + ServerListener.this.username).getBytes()), ServerListener.this.username);
            }
            this.session.setFlag("profile", profile);
            int threshold = this.session.getFlag("compression-threshold", 256);
            this.session.send(new ClientboundLoginCompressionPacket(threshold));
        }
    }

    private class KeepAliveTask
    implements Runnable {
        private Session session;

        public KeepAliveTask(Session session) {
            this.session = session;
        }

        @Override
        public void run() {
            while (this.session.isConnected()) {
                ServerListener.this.lastPingTime = System.currentTimeMillis();
                ServerListener.this.lastPingId = (int)ServerListener.this.lastPingTime;
                this.session.send(new ClientboundKeepAlivePacket(ServerListener.this.lastPingId));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

