/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.login.serverbound;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;

public class ServerboundCustomQueryPacket
implements Packet {
    private final int messageId;
    private final byte[] data;

    public ServerboundCustomQueryPacket(int messageId) {
        this(messageId, null);
    }

    public ServerboundCustomQueryPacket(NetInput in) throws IOException {
        this.messageId = in.readVarInt();
        this.data = (byte[])(in.readBoolean() ? in.readBytes(in.available()) : null);
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.messageId);
        if (this.data != null) {
            out.writeBoolean(true);
            out.writeBytes(this.data);
        } else {
            out.writeBoolean(false);
        }
    }

    public int getMessageId() {
        return this.messageId;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundCustomQueryPacket)) {
            return false;
        }
        ServerboundCustomQueryPacket other = (ServerboundCustomQueryPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMessageId() != other.getMessageId()) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundCustomQueryPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMessageId();
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }

    public String toString() {
        return "ServerboundCustomQueryPacket(messageId=" + this.getMessageId() + ", data=" + Arrays.toString(this.getData()) + ")";
    }

    public ServerboundCustomQueryPacket withMessageId(int messageId) {
        return this.messageId == messageId ? this : new ServerboundCustomQueryPacket(messageId, this.data);
    }

    public ServerboundCustomQueryPacket withData(byte[] data) {
        return this.data == data ? this : new ServerboundCustomQueryPacket(this.messageId, data);
    }

    public ServerboundCustomQueryPacket(int messageId, byte[] data) {
        this.messageId = messageId;
        this.data = data;
    }
}

