/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity.player;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ClientboundSetHealthPacket
implements Packet {
    private final float health;
    private final int food;
    private final float saturation;

    public ClientboundSetHealthPacket(NetInput in) throws IOException {
        this.health = in.readFloat();
        this.food = in.readVarInt();
        this.saturation = in.readFloat();
    }

    public void write(NetOutput out) throws IOException {
        out.writeFloat(this.health);
        out.writeVarInt(this.food);
        out.writeFloat(this.saturation);
    }

    public float getHealth() {
        return this.health;
    }

    public int getFood() {
        return this.food;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetHealthPacket)) {
            return false;
        }
        ClientboundSetHealthPacket other = (ClientboundSetHealthPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getHealth(), other.getHealth()) != 0) {
            return false;
        }
        if (this.getFood() != other.getFood()) {
            return false;
        }
        return Float.compare(this.getSaturation(), other.getSaturation()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetHealthPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getHealth());
        result = result * 59 + this.getFood();
        result = result * 59 + Float.floatToIntBits(this.getSaturation());
        return result;
    }

    public String toString() {
        return "ClientboundSetHealthPacket(health=" + this.getHealth() + ", food=" + this.getFood() + ", saturation=" + this.getSaturation() + ")";
    }

    public ClientboundSetHealthPacket withHealth(float health) {
        return this.health == health ? this : new ClientboundSetHealthPacket(health, this.food, this.saturation);
    }

    public ClientboundSetHealthPacket withFood(int food) {
        return this.food == food ? this : new ClientboundSetHealthPacket(this.health, food, this.saturation);
    }

    public ClientboundSetHealthPacket withSaturation(float saturation) {
        return this.saturation == saturation ? this : new ClientboundSetHealthPacket(this.health, this.food, saturation);
    }

    public ClientboundSetHealthPacket(float health, int food, float saturation) {
        this.health = health;
        this.food = food;
        this.saturation = saturation;
    }
}

