/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity.player;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.mc.protocol.data.game.entity.player.PlayerAction;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundBlockBreakAckPacket
implements Packet {
    @NonNull
    private final PlayerAction action;
    private final boolean successful;
    @NonNull
    private final Position position;
    private final int newState;

    public ClientboundBlockBreakAckPacket(NetInput in) throws IOException {
        this.position = Position.read(in);
        this.newState = in.readVarInt();
        this.action = MagicValues.key(PlayerAction.class, in.readVarInt());
        this.successful = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        Position.write(out, this.position);
        out.writeVarInt(this.newState);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.action).intValue());
        out.writeBoolean(this.successful);
    }

    @NonNull
    public PlayerAction getAction() {
        return this.action;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    public int getNewState() {
        return this.newState;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundBlockBreakAckPacket)) {
            return false;
        }
        ClientboundBlockBreakAckPacket other = (ClientboundBlockBreakAckPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccessful() != other.isSuccessful()) {
            return false;
        }
        if (this.getNewState() != other.getNewState()) {
            return false;
        }
        PlayerAction this$action = this.getAction();
        PlayerAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        return !(this$position == null ? other$position != null : !((Object)this$position).equals(other$position));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundBlockBreakAckPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccessful() ? 79 : 97);
        result = result * 59 + this.getNewState();
        PlayerAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundBlockBreakAckPacket(action=" + (Object)((Object)this.getAction()) + ", successful=" + this.isSuccessful() + ", position=" + this.getPosition() + ", newState=" + this.getNewState() + ")";
    }

    public ClientboundBlockBreakAckPacket withAction(@NonNull PlayerAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ClientboundBlockBreakAckPacket(action, this.successful, this.position, this.newState);
    }

    public ClientboundBlockBreakAckPacket withSuccessful(boolean successful) {
        return this.successful == successful ? this : new ClientboundBlockBreakAckPacket(this.action, successful, this.position, this.newState);
    }

    public ClientboundBlockBreakAckPacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientboundBlockBreakAckPacket(this.action, this.successful, position, this.newState);
    }

    public ClientboundBlockBreakAckPacket withNewState(int newState) {
        return this.newState == newState ? this : new ClientboundBlockBreakAckPacket(this.action, this.successful, this.position, newState);
    }

    public ClientboundBlockBreakAckPacket(@NonNull PlayerAction action, boolean successful, @NonNull Position position, int newState) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        this.action = action;
        this.successful = successful;
        this.position = position;
        this.newState = newState;
    }
}

