/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ClientboundSetEntityLinkPacket
implements Packet {
    private final int entityId;
    private final int attachedToId;

    public ClientboundSetEntityLinkPacket(NetInput in) throws IOException {
        this.entityId = in.readInt();
        this.attachedToId = in.readInt();
    }

    public void write(NetOutput out) throws IOException {
        out.writeInt(this.entityId);
        out.writeInt(this.attachedToId);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getAttachedToId() {
        return this.attachedToId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetEntityLinkPacket)) {
            return false;
        }
        ClientboundSetEntityLinkPacket other = (ClientboundSetEntityLinkPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        return this.getAttachedToId() == other.getAttachedToId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetEntityLinkPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getAttachedToId();
        return result;
    }

    public String toString() {
        return "ClientboundSetEntityLinkPacket(entityId=" + this.getEntityId() + ", attachedToId=" + this.getAttachedToId() + ")";
    }

    public ClientboundSetEntityLinkPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundSetEntityLinkPacket(entityId, this.attachedToId);
    }

    public ClientboundSetEntityLinkPacket withAttachedToId(int attachedToId) {
        return this.attachedToId == attachedToId ? this : new ClientboundSetEntityLinkPacket(this.entityId, attachedToId);
    }

    public ClientboundSetEntityLinkPacket(int entityId, int attachedToId) {
        this.entityId = entityId;
        this.attachedToId = attachedToId;
    }
}

