/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ClientboundMoveEntityPosRotPacket
implements Packet {
    private final int entityId;
    private final double moveX;
    private final double moveY;
    private final double moveZ;
    private final float yaw;
    private final float pitch;
    private final boolean onGround;

    public ClientboundMoveEntityPosRotPacket(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.moveX = (double)in.readShort() / 4096.0;
        this.moveY = (double)in.readShort() / 4096.0;
        this.moveZ = (double)in.readShort() / 4096.0;
        this.yaw = (float)(in.readByte() * 360) / 256.0f;
        this.pitch = (float)(in.readByte() * 360) / 256.0f;
        this.onGround = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeShort((int)(this.moveX * 4096.0));
        out.writeShort((int)(this.moveY * 4096.0));
        out.writeShort((int)(this.moveZ * 4096.0));
        out.writeByte((int)((byte)(this.yaw * 256.0f / 360.0f)));
        out.writeByte((int)((byte)(this.pitch * 256.0f / 360.0f)));
        out.writeBoolean(this.onGround);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public double getMoveX() {
        return this.moveX;
    }

    public double getMoveY() {
        return this.moveY;
    }

    public double getMoveZ() {
        return this.moveZ;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundMoveEntityPosRotPacket)) {
            return false;
        }
        ClientboundMoveEntityPosRotPacket other = (ClientboundMoveEntityPosRotPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (Double.compare(this.getMoveX(), other.getMoveX()) != 0) {
            return false;
        }
        if (Double.compare(this.getMoveY(), other.getMoveY()) != 0) {
            return false;
        }
        if (Double.compare(this.getMoveZ(), other.getMoveZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        return this.isOnGround() == other.isOnGround();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundMoveEntityPosRotPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        long $moveX = Double.doubleToLongBits(this.getMoveX());
        result = result * 59 + (int)($moveX >>> 32 ^ $moveX);
        long $moveY = Double.doubleToLongBits(this.getMoveY());
        result = result * 59 + (int)($moveY >>> 32 ^ $moveY);
        long $moveZ = Double.doubleToLongBits(this.getMoveZ());
        result = result * 59 + (int)($moveZ >>> 32 ^ $moveZ);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        result = result * 59 + (this.isOnGround() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ClientboundMoveEntityPosRotPacket(entityId=" + this.getEntityId() + ", moveX=" + this.getMoveX() + ", moveY=" + this.getMoveY() + ", moveZ=" + this.getMoveZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ", onGround=" + this.isOnGround() + ")";
    }

    public ClientboundMoveEntityPosRotPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundMoveEntityPosRotPacket(entityId, this.moveX, this.moveY, this.moveZ, this.yaw, this.pitch, this.onGround);
    }

    public ClientboundMoveEntityPosRotPacket withMoveX(double moveX) {
        return this.moveX == moveX ? this : new ClientboundMoveEntityPosRotPacket(this.entityId, moveX, this.moveY, this.moveZ, this.yaw, this.pitch, this.onGround);
    }

    public ClientboundMoveEntityPosRotPacket withMoveY(double moveY) {
        return this.moveY == moveY ? this : new ClientboundMoveEntityPosRotPacket(this.entityId, this.moveX, moveY, this.moveZ, this.yaw, this.pitch, this.onGround);
    }

    public ClientboundMoveEntityPosRotPacket withMoveZ(double moveZ) {
        return this.moveZ == moveZ ? this : new ClientboundMoveEntityPosRotPacket(this.entityId, this.moveX, this.moveY, moveZ, this.yaw, this.pitch, this.onGround);
    }

    public ClientboundMoveEntityPosRotPacket withYaw(float yaw) {
        return this.yaw == yaw ? this : new ClientboundMoveEntityPosRotPacket(this.entityId, this.moveX, this.moveY, this.moveZ, yaw, this.pitch, this.onGround);
    }

    public ClientboundMoveEntityPosRotPacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ClientboundMoveEntityPosRotPacket(this.entityId, this.moveX, this.moveY, this.moveZ, this.yaw, pitch, this.onGround);
    }

    public ClientboundMoveEntityPosRotPacket withOnGround(boolean onGround) {
        return this.onGround == onGround ? this : new ClientboundMoveEntityPosRotPacket(this.entityId, this.moveX, this.moveY, this.moveZ, this.yaw, this.pitch, onGround);
    }

    public ClientboundMoveEntityPosRotPacket(int entityId, double moveX, double moveY, double moveZ, float yaw, float pitch, boolean onGround) {
        this.entityId = entityId;
        this.moveX = moveX;
        this.moveY = moveY;
        this.moveZ = moveZ;
        this.yaw = yaw;
        this.pitch = pitch;
        this.onGround = onGround;
    }
}

