/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ClientboundCustomPayloadPacket
implements Packet {
    @NonNull
    private final String channel;
    @NonNull
    private final byte[] data;

    public ClientboundCustomPayloadPacket(NetInput in) throws IOException {
        this.channel = in.readString();
        this.data = in.readBytes(in.available());
    }

    public void write(NetOutput out) throws IOException {
        out.writeString(this.channel);
        out.writeBytes(this.data);
    }

    @NonNull
    public String getChannel() {
        return this.channel;
    }

    @NonNull
    public byte[] getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundCustomPayloadPacket)) {
            return false;
        }
        ClientboundCustomPayloadPacket other = (ClientboundCustomPayloadPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundCustomPayloadPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }

    public String toString() {
        return "ClientboundCustomPayloadPacket(channel=" + this.getChannel() + ", data=" + Arrays.toString(this.getData()) + ")";
    }

    public ClientboundCustomPayloadPacket withChannel(@NonNull String channel) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        return this.channel == channel ? this : new ClientboundCustomPayloadPacket(channel, this.data);
    }

    public ClientboundCustomPayloadPacket withData(@NonNull byte[] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return this.data == data ? this : new ClientboundCustomPayloadPacket(this.channel, data);
    }

    public ClientboundCustomPayloadPacket(@NonNull String channel, @NonNull byte[] data) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.channel = channel;
        this.data = data;
    }
}

