/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.MessageType;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public class ClientboundChatPacket
implements Packet {
    @NonNull
    private final Component message;
    @NonNull
    private final MessageType type;
    @NonNull
    private final UUID senderUuid;

    public ClientboundChatPacket(@NonNull String text) {
        this(DefaultComponentSerializer.get().deserialize((Object)text));
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
    }

    public ClientboundChatPacket(@NonNull Component message) {
        this(message, MessageType.SYSTEM);
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
    }

    public ClientboundChatPacket(@NonNull String text, @NonNull MessageType type) {
        this(DefaultComponentSerializer.get().deserialize((Object)text), type, new UUID(0L, 0L));
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    public ClientboundChatPacket(@NonNull Component message, @NonNull MessageType type) {
        this(message, type, new UUID(0L, 0L));
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    public ClientboundChatPacket(@NonNull String text, @NonNull MessageType type, @NonNull UUID uuid) {
        this(DefaultComponentSerializer.get().deserialize((Object)text), type, uuid);
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
    }

    public ClientboundChatPacket(NetInput in) throws IOException {
        this.message = DefaultComponentSerializer.get().deserialize((Object)in.readString());
        this.type = MagicValues.key(MessageType.class, in.readByte());
        this.senderUuid = in.readUUID();
    }

    public void write(NetOutput out) throws IOException {
        out.writeString((String)DefaultComponentSerializer.get().serialize(this.message));
        out.writeByte(MagicValues.value(Integer.class, (Object)this.type).intValue());
        out.writeUUID(this.senderUuid);
    }

    @NonNull
    public Component getMessage() {
        return this.message;
    }

    @NonNull
    public MessageType getType() {
        return this.type;
    }

    @NonNull
    public UUID getSenderUuid() {
        return this.senderUuid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundChatPacket)) {
            return false;
        }
        ClientboundChatPacket other = (ClientboundChatPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Component this$message = this.getMessage();
        Component other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        MessageType this$type = this.getType();
        MessageType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        UUID this$senderUuid = this.getSenderUuid();
        UUID other$senderUuid = other.getSenderUuid();
        return !(this$senderUuid == null ? other$senderUuid != null : !((Object)this$senderUuid).equals(other$senderUuid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundChatPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Component $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        MessageType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        UUID $senderUuid = this.getSenderUuid();
        result = result * 59 + ($senderUuid == null ? 43 : ((Object)$senderUuid).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundChatPacket(message=" + this.getMessage() + ", type=" + (Object)((Object)this.getType()) + ", senderUuid=" + this.getSenderUuid() + ")";
    }

    public ClientboundChatPacket withMessage(@NonNull Component message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.message == message ? this : new ClientboundChatPacket(message, this.type, this.senderUuid);
    }

    public ClientboundChatPacket withType(@NonNull MessageType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.type == type ? this : new ClientboundChatPacket(this.message, type, this.senderUuid);
    }

    public ClientboundChatPacket withSenderUuid(@NonNull UUID senderUuid) {
        if (senderUuid == null) {
            throw new NullPointerException("senderUuid is marked non-null but is null");
        }
        return this.senderUuid == senderUuid ? this : new ClientboundChatPacket(this.message, this.type, senderUuid);
    }

    public ClientboundChatPacket(@NonNull Component message, @NonNull MessageType type, @NonNull UUID senderUuid) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (senderUuid == null) {
            throw new NullPointerException("senderUuid is marked non-null but is null");
        }
        this.message = message;
        this.type = type;
        this.senderUuid = senderUuid;
    }
}

