/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.setting.Difficulty;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundChangeDifficultyPacket
implements Packet {
    @NonNull
    private final Difficulty difficulty;
    private final boolean difficultyLocked;

    public ClientboundChangeDifficultyPacket(NetInput in) throws IOException {
        this.difficulty = MagicValues.key(Difficulty.class, in.readUnsignedByte());
        this.difficultyLocked = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        out.writeByte(MagicValues.value(Integer.class, (Object)this.difficulty).intValue());
        out.writeBoolean(this.difficultyLocked);
    }

    @NonNull
    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public boolean isDifficultyLocked() {
        return this.difficultyLocked;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundChangeDifficultyPacket)) {
            return false;
        }
        ClientboundChangeDifficultyPacket other = (ClientboundChangeDifficultyPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDifficultyLocked() != other.isDifficultyLocked()) {
            return false;
        }
        Difficulty this$difficulty = this.getDifficulty();
        Difficulty other$difficulty = other.getDifficulty();
        return !(this$difficulty == null ? other$difficulty != null : !((Object)((Object)this$difficulty)).equals((Object)other$difficulty));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundChangeDifficultyPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDifficultyLocked() ? 79 : 97);
        Difficulty $difficulty = this.getDifficulty();
        result = result * 59 + ($difficulty == null ? 43 : ((Object)((Object)$difficulty)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundChangeDifficultyPacket(difficulty=" + (Object)((Object)this.getDifficulty()) + ", difficultyLocked=" + this.isDifficultyLocked() + ")";
    }

    public ClientboundChangeDifficultyPacket withDifficulty(@NonNull Difficulty difficulty) {
        if (difficulty == null) {
            throw new NullPointerException("difficulty is marked non-null but is null");
        }
        return this.difficulty == difficulty ? this : new ClientboundChangeDifficultyPacket(difficulty, this.difficultyLocked);
    }

    public ClientboundChangeDifficultyPacket withDifficultyLocked(boolean difficultyLocked) {
        return this.difficultyLocked == difficultyLocked ? this : new ClientboundChangeDifficultyPacket(this.difficulty, difficultyLocked);
    }

    public ClientboundChangeDifficultyPacket(@NonNull Difficulty difficulty, boolean difficultyLocked) {
        if (difficulty == null) {
            throw new NullPointerException("difficulty is marked non-null but is null");
        }
        this.difficulty = difficulty;
        this.difficultyLocked = difficultyLocked;
    }
}

