/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.entity.metadata;

import com.github.steveice10.mc.protocol.data.game.NBT;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import java.io.IOException;

public class ItemStack {
    private final int id;
    private final int amount;
    private final CompoundTag nbt;

    public ItemStack(int id) {
        this(id, 1);
    }

    public ItemStack(int id, int amount) {
        this(id, amount, null);
    }

    public static ItemStack read(NetInput in) throws IOException {
        boolean present = in.readBoolean();
        if (!present) {
            return null;
        }
        int item = in.readVarInt();
        return new ItemStack(item, in.readByte(), NBT.read(in));
    }

    public static void write(NetOutput out, ItemStack item) throws IOException {
        out.writeBoolean(item != null);
        if (item != null) {
            out.writeVarInt(item.getId());
            out.writeByte(item.getAmount());
            NBT.write(out, item.getNbt());
        }
    }

    public int getId() {
        return this.id;
    }

    public int getAmount() {
        return this.amount;
    }

    public CompoundTag getNbt() {
        return this.nbt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemStack)) {
            return false;
        }
        ItemStack other = (ItemStack)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        CompoundTag this$nbt = this.getNbt();
        CompoundTag other$nbt = other.getNbt();
        return !(this$nbt == null ? other$nbt != null : !this$nbt.equals(other$nbt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemStack;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getAmount();
        CompoundTag $nbt = this.getNbt();
        result = result * 59 + ($nbt == null ? 43 : $nbt.hashCode());
        return result;
    }

    public String toString() {
        return "ItemStack(id=" + this.getId() + ", amount=" + this.getAmount() + ", nbt=" + this.getNbt() + ")";
    }

    public ItemStack(int id, int amount, CompoundTag nbt) {
        this.id = id;
        this.amount = amount;
        this.nbt = nbt;
    }
}

