/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.chunk;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class NibbleArray3d {
    @NonNull
    private final byte[] data;

    public NibbleArray3d(int size) {
        this(new byte[size >> 1]);
    }

    public NibbleArray3d(@NonNull NetInput in, int size) throws IOException {
        this(in.readBytes(size));
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
    }

    public void write(@NonNull NetOutput out) throws IOException {
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        out.writeBytes(this.data);
    }

    public int get(int x, int y, int z) {
        int key = y << 8 | z << 4 | x;
        int index = key >> 1;
        int part = key & 1;
        return part == 0 ? this.data[index] & 0xF : this.data[index] >> 4 & 0xF;
    }

    public void set(int x, int y, int z, int val) {
        int key = y << 8 | z << 4 | x;
        int index = key >> 1;
        int part = key & 1;
        this.data[index] = part == 0 ? (byte)(this.data[index] & 0xF0 | val & 0xF) : (byte)(this.data[index] & 0xF | (val & 0xF) << 4);
    }

    public void fill(int val) {
        for (int index = 0; index < this.data.length << 1; ++index) {
            int ind = index >> 1;
            int part = index & 1;
            this.data[ind] = part == 0 ? (byte)(this.data[ind] & 0xF0 | val & 0xF) : (byte)(this.data[ind] & 0xF | (val & 0xF) << 4);
        }
    }

    @NonNull
    public byte[] getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NibbleArray3d)) {
            return false;
        }
        NibbleArray3d other = (NibbleArray3d)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof NibbleArray3d;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }

    public String toString() {
        return "NibbleArray3d(data=" + Arrays.toString(this.getData()) + ")";
    }

    public NibbleArray3d(@NonNull byte[] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.data = data;
    }
}

