/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.chunk;

import com.github.steveice10.mc.protocol.data.game.chunk.BitStorage;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.GlobalPalette;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.ListPalette;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.MapPalette;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.Palette;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.PaletteType;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.SingletonPalette;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import java.io.IOException;
import lombok.NonNull;

public class DataPalette {
    public static final int GLOBAL_PALETTE_BITS_PER_ENTRY = 14;
    @NonNull
    private Palette palette;
    private BitStorage storage;
    private final PaletteType paletteType;
    private final int globalPaletteBits;

    public static DataPalette createForChunk() {
        return DataPalette.createForChunk(14);
    }

    public static DataPalette createForChunk(int globalPaletteBits) {
        return DataPalette.createEmpty(PaletteType.CHUNK, globalPaletteBits);
    }

    public static DataPalette createForBiome(int globalPaletteBits) {
        return DataPalette.createEmpty(PaletteType.BIOME, globalPaletteBits);
    }

    public static DataPalette createEmpty(PaletteType paletteType, int globalPaletteBits) {
        return new DataPalette(new ListPalette(paletteType.getMinBitsPerEntry()), new BitStorage(paletteType.getMinBitsPerEntry(), paletteType.getStorageSize()), paletteType, globalPaletteBits);
    }

    public static DataPalette read(NetInput in, PaletteType paletteType, int globalPaletteBits) throws IOException {
        BitStorage storage;
        byte bitsPerEntry = in.readByte();
        Palette palette = DataPalette.readPalette(paletteType, bitsPerEntry, in);
        if (!(palette instanceof SingletonPalette)) {
            int length = in.readVarInt();
            storage = new BitStorage(bitsPerEntry, paletteType.getStorageSize(), in.readLongs(length));
        } else {
            in.readVarInt();
            storage = null;
        }
        return new DataPalette(palette, storage, paletteType, globalPaletteBits);
    }

    public static void write(NetOutput out, DataPalette palette) throws IOException {
        if (palette.palette instanceof SingletonPalette) {
            out.writeByte(0);
            out.writeVarInt(palette.palette.idToState(0));
            out.writeVarInt(0);
            return;
        }
        out.writeByte(palette.storage.getBitsPerEntry());
        if (!(palette.palette instanceof GlobalPalette)) {
            int paletteLength = palette.palette.size();
            out.writeVarInt(paletteLength);
            for (int i = 0; i < paletteLength; ++i) {
                out.writeVarInt(palette.palette.idToState(i));
            }
        }
        long[] data = palette.storage.getData();
        out.writeVarInt(data.length);
        out.writeLongs(data);
    }

    public int get(int x, int y, int z) {
        if (this.storage != null) {
            int id = this.storage.get(DataPalette.index(x, y, z));
            return this.palette.idToState(id);
        }
        return this.palette.idToState(0);
    }

    public int set(int x, int y, int z, int state) {
        int id = this.palette.stateToId(state);
        if (id == -1) {
            this.resize();
            id = this.palette.stateToId(state);
        }
        if (this.storage != null) {
            int index = DataPalette.index(x, y, z);
            int curr = this.storage.get(index);
            this.storage.set(index, id);
            return curr;
        }
        return state;
    }

    private static Palette readPalette(PaletteType paletteType, int bitsPerEntry, NetInput in) throws IOException {
        if (bitsPerEntry > paletteType.getMaxBitsPerEntry()) {
            return new GlobalPalette();
        }
        if (bitsPerEntry == 0) {
            return new SingletonPalette(in);
        }
        if (bitsPerEntry <= paletteType.getMinBitsPerEntry()) {
            return new ListPalette(bitsPerEntry, in);
        }
        return new MapPalette(bitsPerEntry, in);
    }

    private int sanitizeBitsPerEntry(int bitsPerEntry) {
        if (bitsPerEntry <= this.paletteType.getMaxBitsPerEntry()) {
            return Math.max(this.paletteType.getMinBitsPerEntry(), bitsPerEntry);
        }
        return 14;
    }

    private void resize() {
        Palette oldPalette = this.palette;
        BitStorage oldData = this.storage;
        int bitsPerEntry = this.sanitizeBitsPerEntry(oldPalette instanceof SingletonPalette ? 1 : oldData.getBitsPerEntry() + 1);
        this.palette = DataPalette.createPalette(bitsPerEntry, this.paletteType);
        this.storage = new BitStorage(bitsPerEntry, this.paletteType.getStorageSize());
        if (oldPalette instanceof SingletonPalette) {
            for (int i = 0; i < this.paletteType.getStorageSize(); ++i) {
                this.storage.set(i, 0);
            }
        } else {
            for (int i = 0; i < this.paletteType.getStorageSize(); ++i) {
                this.storage.set(i, this.palette.stateToId(oldPalette.idToState(oldData.get(i))));
            }
        }
    }

    private static Palette createPalette(int bitsPerEntry, PaletteType paletteType) {
        if (bitsPerEntry <= paletteType.getMinBitsPerEntry()) {
            return new ListPalette(bitsPerEntry);
        }
        if (bitsPerEntry <= paletteType.getMaxBitsPerEntry()) {
            return new MapPalette(bitsPerEntry);
        }
        return new GlobalPalette();
    }

    private static int index(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    @NonNull
    public Palette getPalette() {
        return this.palette;
    }

    public BitStorage getStorage() {
        return this.storage;
    }

    public PaletteType getPaletteType() {
        return this.paletteType;
    }

    public int getGlobalPaletteBits() {
        return this.globalPaletteBits;
    }

    public void setPalette(@NonNull Palette palette) {
        if (palette == null) {
            throw new NullPointerException("palette is marked non-null but is null");
        }
        this.palette = palette;
    }

    public void setStorage(BitStorage storage) {
        this.storage = storage;
    }

    public DataPalette(@NonNull Palette palette, BitStorage storage, PaletteType paletteType, int globalPaletteBits) {
        if (palette == null) {
            throw new NullPointerException("palette is marked non-null but is null");
        }
        this.palette = palette;
        this.storage = storage;
        this.paletteType = paletteType;
        this.globalPaletteBits = globalPaletteBits;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataPalette)) {
            return false;
        }
        DataPalette other = (DataPalette)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getGlobalPaletteBits() != other.getGlobalPaletteBits()) {
            return false;
        }
        Palette this$palette = this.getPalette();
        Palette other$palette = other.getPalette();
        if (this$palette == null ? other$palette != null : !this$palette.equals(other$palette)) {
            return false;
        }
        BitStorage this$storage = this.getStorage();
        BitStorage other$storage = other.getStorage();
        if (this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage)) {
            return false;
        }
        PaletteType this$paletteType = this.getPaletteType();
        PaletteType other$paletteType = other.getPaletteType();
        return !(this$paletteType == null ? other$paletteType != null : !((Object)((Object)this$paletteType)).equals((Object)other$paletteType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataPalette;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getGlobalPaletteBits();
        Palette $palette = this.getPalette();
        result = result * 59 + ($palette == null ? 43 : $palette.hashCode());
        BitStorage $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        PaletteType $paletteType = this.getPaletteType();
        result = result * 59 + ($paletteType == null ? 43 : ((Object)((Object)$paletteType)).hashCode());
        return result;
    }

    public String toString() {
        return "DataPalette(palette=" + this.getPalette() + ", storage=" + this.getStorage() + ", paletteType=" + (Object)((Object)this.getPaletteType()) + ", globalPaletteBits=" + this.getGlobalPaletteBits() + ")";
    }
}

