/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.chunk;

import java.util.Arrays;
import lombok.NonNull;

public class BitStorage {
    private static final int[] MAGIC_VALUES = new int[]{-1, -1, 0, Integer.MIN_VALUE, 0, 0, 0x55555555, 0x55555555, 0, Integer.MIN_VALUE, 0, 1, 0x33333333, 0x33333333, 0, 0x2AAAAAAA, 0x2AAAAAAA, 0, 0x24924924, 0x24924924, 0, Integer.MIN_VALUE, 0, 2, 0x1C71C71C, 0x1C71C71C, 0, 0x19999999, 0x19999999, 0, 390451572, 390451572, 0, 0x15555555, 0x15555555, 0, 0x13B13B13, 0x13B13B13, 0, 306783378, 306783378, 0, 0x11111111, 0x11111111, 0, Integer.MIN_VALUE, 0, 3, 0xF0F0F0F, 0xF0F0F0F, 0, 0xE38E38E, 0xE38E38E, 0, 226050910, 226050910, 0, 0xCCCCCCC, 0xCCCCCCC, 0, 0xC30C30C, 0xC30C30C, 0, 195225786, 195225786, 0, 186737708, 186737708, 0, 0xAAAAAAA, 0xAAAAAAA, 0, 171798691, 171798691, 0, 0x9D89D89, 0x9D89D89, 0, 159072862, 159072862, 0, 0x9249249, 0x9249249, 0, 148102320, 148102320, 0, 0x8888888, 0x8888888, 0, 138547332, 138547332, 0, Integer.MIN_VALUE, 0, 4, 130150524, 130150524, 0, 0x7878787, 0x7878787, 0, 0x7507507, 0x7507507, 0, 0x71C71C7, 0x71C71C7, 0, 116080197, 116080197, 0, 113025455, 113025455, 0, 0x6906906, 0x6906906, 0, 0x6666666, 0x6666666, 0, 104755299, 104755299, 0, 0x6186186, 0x6186186, 0, 99882960, 99882960, 0, 97612893, 97612893, 0, 0x5B05B05, 0x5B05B05, 0, 93368854, 93368854, 0, 91382282, 91382282, 0, 0x5555555, 0x5555555, 0, 87652393, 87652393, 0, 85899345, 85899345, 0, 0x5050505, 0x5050505, 0, 0x4EC4EC4, 0x4EC4EC4, 0, 81037118, 81037118, 0, 79536431, 79536431, 0, 78090314, 78090314, 0, 0x4924924, 0x4924924, 0, 75350303, 75350303, 0, 74051160, 74051160, 0, 72796055, 72796055, 0, 0x4444444, 0x4444444, 0, 70409299, 70409299, 0, 69273666, 69273666, 0, 0x4104104, 0x4104104, 0, Integer.MIN_VALUE, 0, 5};
    @NonNull
    private final long[] data;
    private final int bitsPerEntry;
    private final int size;
    private final long maxValue;
    private final int valuesPerLong;
    private final long divideMultiply;
    private final long divideAdd;
    private final int divideShift;

    public BitStorage(int bitsPerEntry, int size) {
        this(bitsPerEntry, size, null);
    }

    public BitStorage(int bitsPerEntry, int size, long[] data) {
        if (bitsPerEntry < 1 || bitsPerEntry > 32) {
            throw new IllegalArgumentException("bitsPerEntry must be between 1 and 32, inclusive.");
        }
        this.bitsPerEntry = bitsPerEntry;
        this.size = size;
        this.maxValue = (1L << bitsPerEntry) - 1L;
        this.valuesPerLong = (char)(64 / bitsPerEntry);
        int expectedLength = (size + this.valuesPerLong - 1) / this.valuesPerLong;
        if (data != null) {
            if (data.length != expectedLength) {
                throw new IllegalArgumentException("Expected " + expectedLength + " longs but got " + data.length + " longs");
            }
            this.data = data;
        } else {
            this.data = new long[expectedLength];
        }
        int magicIndex = 3 * (this.valuesPerLong - 1);
        this.divideMultiply = Integer.toUnsignedLong(MAGIC_VALUES[magicIndex]);
        this.divideAdd = Integer.toUnsignedLong(MAGIC_VALUES[magicIndex + 1]);
        this.divideShift = MAGIC_VALUES[magicIndex + 2];
    }

    public int get(int index) {
        if (index < 0 || index > this.size - 1) {
            throw new IndexOutOfBoundsException();
        }
        int cellIndex = this.cellIndex(index);
        int bitIndex = this.bitIndex(index, cellIndex);
        return (int)(this.data[cellIndex] >> bitIndex & this.maxValue);
    }

    public void set(int index, int value) {
        if (index < 0 || index > this.size - 1) {
            throw new IndexOutOfBoundsException();
        }
        if (value < 0 || (long)value > this.maxValue) {
            throw new IllegalArgumentException("Value cannot be outside of accepted range.");
        }
        int cellIndex = this.cellIndex(index);
        int bitIndex = this.bitIndex(index, cellIndex);
        this.data[cellIndex] = this.data[cellIndex] & (this.maxValue << bitIndex ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & this.maxValue) << bitIndex;
    }

    public int[] toIntArray() {
        int[] result = new int[this.size];
        int index = 0;
        for (long cell : this.data) {
            for (int bitIndex = 0; bitIndex < this.valuesPerLong; ++bitIndex) {
                result[index++] = (int)(cell & this.maxValue);
                cell >>= this.bitsPerEntry;
                if (index < this.size) continue;
                return result;
            }
        }
        return result;
    }

    private int cellIndex(int index) {
        return (int)((long)index * this.divideMultiply + this.divideAdd >> 32 >> this.divideShift);
    }

    private int bitIndex(int index, int cellIndex) {
        return (index - cellIndex * this.valuesPerLong) * this.bitsPerEntry;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BitStorage)) {
            return false;
        }
        BitStorage other = (BitStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBitsPerEntry() != other.getBitsPerEntry()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.maxValue != other.maxValue) {
            return false;
        }
        if (this.valuesPerLong != other.valuesPerLong) {
            return false;
        }
        if (this.divideMultiply != other.divideMultiply) {
            return false;
        }
        if (this.divideAdd != other.divideAdd) {
            return false;
        }
        if (this.divideShift != other.divideShift) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof BitStorage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBitsPerEntry();
        result = result * 59 + this.getSize();
        long $maxValue = this.maxValue;
        result = result * 59 + (int)($maxValue >>> 32 ^ $maxValue);
        result = result * 59 + this.valuesPerLong;
        long $divideMultiply = this.divideMultiply;
        result = result * 59 + (int)($divideMultiply >>> 32 ^ $divideMultiply);
        long $divideAdd = this.divideAdd;
        result = result * 59 + (int)($divideAdd >>> 32 ^ $divideAdd);
        result = result * 59 + this.divideShift;
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }

    @NonNull
    public long[] getData() {
        return this.data;
    }

    public int getBitsPerEntry() {
        return this.bitsPerEntry;
    }

    public int getSize() {
        return this.size;
    }
}

