/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory;

import io.netty.buffer.ByteBuf;
import java.util.OptionalInt;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundSetBeaconPacket
implements MinecraftPacket {
    private final OptionalInt primaryEffect;
    private final OptionalInt secondaryEffect;

    public ServerboundSetBeaconPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.primaryEffect = in.readBoolean() ? OptionalInt.of(helper.readVarInt(in)) : OptionalInt.empty();
        this.secondaryEffect = in.readBoolean() ? OptionalInt.of(helper.readVarInt(in)) : OptionalInt.empty();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeBoolean(this.primaryEffect.isPresent());
        if (this.primaryEffect.isPresent()) {
            helper.writeVarInt(out, this.primaryEffect.getAsInt());
        }
        out.writeBoolean(this.secondaryEffect.isPresent());
        if (this.secondaryEffect.isPresent()) {
            helper.writeVarInt(out, this.secondaryEffect.getAsInt());
        }
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public OptionalInt getPrimaryEffect() {
        return this.primaryEffect;
    }

    public OptionalInt getSecondaryEffect() {
        return this.secondaryEffect;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSetBeaconPacket)) {
            return false;
        }
        ServerboundSetBeaconPacket other = (ServerboundSetBeaconPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OptionalInt this$primaryEffect = this.getPrimaryEffect();
        OptionalInt other$primaryEffect = other.getPrimaryEffect();
        if (this$primaryEffect == null ? other$primaryEffect != null : !((Object)this$primaryEffect).equals(other$primaryEffect)) {
            return false;
        }
        OptionalInt this$secondaryEffect = this.getSecondaryEffect();
        OptionalInt other$secondaryEffect = other.getSecondaryEffect();
        return !(this$secondaryEffect == null ? other$secondaryEffect != null : !((Object)this$secondaryEffect).equals(other$secondaryEffect));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundSetBeaconPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OptionalInt $primaryEffect = this.getPrimaryEffect();
        result = result * 59 + ($primaryEffect == null ? 43 : ((Object)$primaryEffect).hashCode());
        OptionalInt $secondaryEffect = this.getSecondaryEffect();
        result = result * 59 + ($secondaryEffect == null ? 43 : ((Object)$secondaryEffect).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundSetBeaconPacket(primaryEffect=" + this.getPrimaryEffect() + ", secondaryEffect=" + this.getSecondaryEffect() + ")";
    }

    public @NonNull ServerboundSetBeaconPacket withPrimaryEffect(OptionalInt primaryEffect) {
        return this.primaryEffect == primaryEffect ? this : new ServerboundSetBeaconPacket(primaryEffect, this.secondaryEffect);
    }

    public @NonNull ServerboundSetBeaconPacket withSecondaryEffect(OptionalInt secondaryEffect) {
        return this.secondaryEffect == secondaryEffect ? this : new ServerboundSetBeaconPacket(this.primaryEffect, secondaryEffect);
    }

    public ServerboundSetBeaconPacket(OptionalInt primaryEffect, OptionalInt secondaryEffect) {
        this.primaryEffect = primaryEffect;
        this.secondaryEffect = secondaryEffect;
    }
}

