/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory;

import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.AdvancementTabAction;

public class ServerboundSeenAdvancementsPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final AdvancementTabAction action;
    private final String tabId;

    public ServerboundSeenAdvancementsPacket() {
        this.action = AdvancementTabAction.CLOSED_SCREEN;
        this.tabId = null;
    }

    public ServerboundSeenAdvancementsPacket(@lombok.NonNull String tabId) {
        if (tabId == null) {
            throw new NullPointerException("tabId is marked non-null but is null");
        }
        this.action = AdvancementTabAction.OPENED_TAB;
        this.tabId = tabId;
    }

    public String getTabId() {
        if (this.action != AdvancementTabAction.OPENED_TAB) {
            throw new IllegalStateException("tabId is only set if action is " + AdvancementTabAction.OPENED_TAB + " but it was " + this.action);
        }
        return this.tabId;
    }

    public ServerboundSeenAdvancementsPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.action = AdvancementTabAction.from(helper.readVarInt(in));
        this.tabId = switch (this.action) {
            default -> throw new IncompatibleClassChangeError();
            case AdvancementTabAction.CLOSED_SCREEN -> null;
            case AdvancementTabAction.OPENED_TAB -> helper.readString(in);
        };
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.action.ordinal());
        Consumer<String> tabIdWriter = switch (this.action) {
            default -> throw new IncompatibleClassChangeError();
            case AdvancementTabAction.CLOSED_SCREEN -> tabId -> {};
            case AdvancementTabAction.OPENED_TAB -> tabId -> helper.writeString(out, (String)tabId);
        };
        tabIdWriter.accept(this.tabId);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public @NonNull String toString() {
        return "ServerboundSeenAdvancementsPacket(action=" + this.getAction() + ", tabId=" + this.getTabId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSeenAdvancementsPacket)) {
            return false;
        }
        ServerboundSeenAdvancementsPacket other = (ServerboundSeenAdvancementsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AdvancementTabAction this$action = this.getAction();
        AdvancementTabAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        String this$tabId = this.getTabId();
        String other$tabId = other.getTabId();
        return !(this$tabId == null ? other$tabId != null : !this$tabId.equals(other$tabId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundSeenAdvancementsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AdvancementTabAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        String $tabId = this.getTabId();
        result = result * 59 + ($tabId == null ? 43 : $tabId.hashCode());
        return result;
    }

    @lombok.NonNull
    public AdvancementTabAction getAction() {
        return this.action;
    }
}

