/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockChangeEntry;

public class ClientboundBlockUpdatePacket
implements MinecraftPacket {
    @lombok.NonNull
    private final BlockChangeEntry entry;

    public ClientboundBlockUpdatePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.entry = new BlockChangeEntry(helper.readPosition(in), helper.readVarInt(in));
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writePosition(out, this.entry.getPosition());
        helper.writeVarInt(out, this.entry.getBlock());
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @lombok.NonNull
    public BlockChangeEntry getEntry() {
        return this.entry;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundBlockUpdatePacket)) {
            return false;
        }
        ClientboundBlockUpdatePacket other = (ClientboundBlockUpdatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BlockChangeEntry this$entry = this.getEntry();
        BlockChangeEntry other$entry = other.getEntry();
        return !(this$entry == null ? other$entry != null : !((Object)this$entry).equals(other$entry));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundBlockUpdatePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BlockChangeEntry $entry = this.getEntry();
        result = result * 59 + ($entry == null ? 43 : ((Object)$entry).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundBlockUpdatePacket(entry=" + this.getEntry() + ")";
    }

    public @NonNull ClientboundBlockUpdatePacket withEntry(@lombok.NonNull BlockChangeEntry entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return this.entry == entry ? this : new ClientboundBlockUpdatePacket(entry);
    }

    public ClientboundBlockUpdatePacket(@lombok.NonNull BlockChangeEntry entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.entry = entry;
    }
}

