/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class ClientboundContainerSetContentPacket
implements MinecraftPacket {
    private final int containerId;
    private final int stateId;
    private final @Nullable ItemStack @lombok.NonNull [] items;
    private final @Nullable ItemStack carriedItem;

    public ClientboundContainerSetContentPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.containerId = helper.readVarInt(in);
        this.stateId = helper.readVarInt(in);
        this.items = new ItemStack[helper.readVarInt(in)];
        for (int index = 0; index < this.items.length; ++index) {
            this.items[index] = helper.readOptionalItemStack(in);
        }
        this.carriedItem = helper.readOptionalItemStack(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.containerId);
        helper.writeVarInt(out, this.stateId);
        helper.writeVarInt(out, this.items.length);
        for (ItemStack item : this.items) {
            helper.writeOptionalItemStack(out, item);
        }
        helper.writeOptionalItemStack(out, this.carriedItem);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getStateId() {
        return this.stateId;
    }

    public @Nullable ItemStack @lombok.NonNull [] getItems() {
        return this.items;
    }

    public @Nullable ItemStack getCarriedItem() {
        return this.carriedItem;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundContainerSetContentPacket)) {
            return false;
        }
        ClientboundContainerSetContentPacket other = (ClientboundContainerSetContentPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        if (this.getStateId() != other.getStateId()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getItems(), other.getItems())) {
            return false;
        }
        ItemStack this$carriedItem = this.getCarriedItem();
        ItemStack other$carriedItem = other.getCarriedItem();
        return !(this$carriedItem == null ? other$carriedItem != null : !((Object)this$carriedItem).equals(other$carriedItem));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundContainerSetContentPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        result = result * 59 + this.getStateId();
        result = result * 59 + Arrays.deepHashCode(this.getItems());
        ItemStack $carriedItem = this.getCarriedItem();
        result = result * 59 + ($carriedItem == null ? 43 : ((Object)$carriedItem).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundContainerSetContentPacket(containerId=" + this.getContainerId() + ", stateId=" + this.getStateId() + ", items=" + Arrays.deepToString(this.getItems()) + ", carriedItem=" + this.getCarriedItem() + ")";
    }

    public @NonNull ClientboundContainerSetContentPacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ClientboundContainerSetContentPacket(containerId, this.stateId, this.items, this.carriedItem);
    }

    public @NonNull ClientboundContainerSetContentPacket withStateId(int stateId) {
        return this.stateId == stateId ? this : new ClientboundContainerSetContentPacket(this.containerId, stateId, this.items, this.carriedItem);
    }

    public @NonNull ClientboundContainerSetContentPacket withItems(@Nullable ItemStack @lombok.NonNull [] items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        return this.items == items ? this : new ClientboundContainerSetContentPacket(this.containerId, this.stateId, items, this.carriedItem);
    }

    public @NonNull ClientboundContainerSetContentPacket withCarriedItem(@Nullable ItemStack carriedItem) {
        return this.carriedItem == carriedItem ? this : new ClientboundContainerSetContentPacket(this.containerId, this.stateId, this.items, carriedItem);
    }

    public ClientboundContainerSetContentPacket(int containerId, int stateId, @Nullable ItemStack @lombok.NonNull [] items, @Nullable ItemStack carriedItem) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        this.containerId = containerId;
        this.stateId = stateId;
        this.items = items;
        this.carriedItem = carriedItem;
    }
}

