/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundSetEntityLinkPacket
implements MinecraftPacket {
    private final int entityId;
    private final int attachedToId;

    public ClientboundSetEntityLinkPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.entityId = in.readInt();
        this.attachedToId = in.readInt();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeInt(this.entityId);
        out.writeInt(this.attachedToId);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getAttachedToId() {
        return this.attachedToId;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetEntityLinkPacket)) {
            return false;
        }
        ClientboundSetEntityLinkPacket other = (ClientboundSetEntityLinkPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        return this.getAttachedToId() == other.getAttachedToId();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetEntityLinkPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getAttachedToId();
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetEntityLinkPacket(entityId=" + this.getEntityId() + ", attachedToId=" + this.getAttachedToId() + ")";
    }

    public @NonNull ClientboundSetEntityLinkPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundSetEntityLinkPacket(entityId, this.attachedToId);
    }

    public @NonNull ClientboundSetEntityLinkPacket withAttachedToId(int attachedToId) {
        return this.attachedToId == attachedToId ? this : new ClientboundSetEntityLinkPacket(this.entityId, attachedToId);
    }

    public ClientboundSetEntityLinkPacket(int entityId, int attachedToId) {
        this.entityId = entityId;
        this.attachedToId = attachedToId;
    }
}

